/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.receiving.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.liby.delivery.entity.OemDeliveryInstead;
import com.els.liby.receiving.command.CollectedBackSapCommand;
import com.els.liby.receiving.entity.OemReceivingInstead;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemReceivingStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;

public class CollectedCommand
extends AbstractCommand<Integer> {
    private List<OemReceivingInstead> oemReceivingInsteads;

    public CollectedCommand(List<OemReceivingInstead> oemReceivingInsteads) {
        this.oemReceivingInsteads = oemReceivingInsteads;
    }

    public Integer execute(ICommandInvoker context) {
        this.vaildStatus(this.oemReceivingInsteads);
        List<OemReceivingInstead> effectiveInsteads = this.getEffectiveInsteadsByOrderStatus(this.oemReceivingInsteads);
        CollectedBackSapCommand command = new CollectedBackSapCommand(effectiveInsteads);
        List codes = (List)context.invoke((AbstractCommand)command);
        List<OemReceivingInstead> collectedSuccessInstead = effectiveInsteads.stream().filter(o -> codes.contains(o.getReceivingVoucherNo())).collect(Collectors.toList());
        this.updateReceivingStatusByDeliveryInsteadId(collectedSuccessInstead);
        return collectedSuccessInstead.size();
    }

    private void updateReceivingStatusByDeliveryInsteadId(List<OemReceivingInstead> insteads) {
        List<String> deliveryInsteadIds = insteads.stream().map(i -> i.getDeliveryVoucherId()).collect(Collectors.toList());
        OemContextUtils.getOemDeliveryInsteadService().modifyReceivingStatusbyids(OemReceivingStatusEnum.RECEIVED.getValue(), deliveryInsteadIds);
    }

    private List<OemReceivingInstead> getEffectiveInsteadsByOrderStatus(List<OemReceivingInstead> oemReceivingInsteads) {
        List<OemReceivingInstead> list = oemReceivingInsteads.stream().filter(o -> {
            OemDeliveryInstead deliveryInstead = (OemDeliveryInstead)OemContextUtils.getOemDeliveryInsteadService().queryObjById(o.getDeliveryVoucherId());
            if (!OemWriteOffEnum.UN_WRITE_OFF.getValue().equals(deliveryInstead.getWriteoffFlag())) {
                OemReceivingInstead instead = new OemReceivingInstead();
                instead.setId(o.getId());
                instead.setConfirmStatus(OemConfirmStatusEnum.COLLECTED_FAIL.getValue());
                instead.setConfirmFailReason(MessageFormat.format("\u4ee3\u53d1\u8d27\u51ed\u8bc1\uff1a{0}\uff0c{1}\u884c\u5df2\u5220\u9664", o.getDeliveryVoucherNo(), o.getDeliveryVoucherItemNo()));
                OemContextUtils.getOemReceivingInsteadService().modifyObj(instead);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        return list;
    }

    private void vaildStatus(List<OemReceivingInstead> oemReceivingInsteads) {
        oemReceivingInsteads.stream().forEach(o -> {
            OemReceivingInstead initialData = (OemReceivingInstead)OemContextUtils.getOemReceivingInsteadService().queryObjById(o.getId());
            if (initialData.getConfirmStatus().equals(OemConfirmStatusEnum.COLLECTED.getValue())) {
                throw new CommonException(MessageFormat.format("\u63d0\u4ea4\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a{0}\uff1b\u5df2\u786e\u8ba4", o.getReceivingVoucherNo()));
            }
            if (!initialData.getWriteoffFlag().equals(OemWriteOffEnum.UN_WRITE_OFF.getValue())) {
                throw new CommonException(MessageFormat.format("\u63d0\u4ea4\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a{0}\uff1b\u5df2\u51b2\u9500", o.getReceivingVoucherNo()));
            }
        });
    }
}

