/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.receiving.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.delivery.entity.OemDeliveryInstead;
import com.els.liby.receiving.entity.OemReceivingInstead;
import com.els.liby.util.GetVoucherNoUtil;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemReceivingStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class CreateReceivingInsteadCommand
extends AbstractCommand<List<OemReceivingInstead>> {
    private List<OemReceivingInstead> insteads;

    public CreateReceivingInsteadCommand(List<OemReceivingInstead> insteads) {
        this.insteads = insteads;
    }

    public List<OemReceivingInstead> execute(ICommandInvoker context) {
        this.vaild(this.insteads);
        this.init(this.insteads);
        OemContextUtils.getOemReceivingInsteadService().addAll(this.insteads);
        this.updateReceivingStatusByDeliveryInsteadId(this.insteads);
        return this.insteads;
    }

    private void updateReceivingStatusByDeliveryInsteadId(List<OemReceivingInstead> insteads) {
        List<String> deliveryInsteadIds = insteads.stream().map(i -> i.getDeliveryVoucherId()).collect(Collectors.toList());
        OemContextUtils.getOemDeliveryInsteadService().modifyReceivingStatusbyids(OemReceivingStatusEnum.RECEIVEING.getValue(), deliveryInsteadIds);
    }

    private void init(List<OemReceivingInstead> insteads) {
        insteads.stream().forEach(instead -> {
            OemDeliveryInstead deliveryInstead = (OemDeliveryInstead)OemContextUtils.getOemDeliveryInsteadService().queryObjById(instead.getDeliveryVoucherId());
            if (!OemWriteOffEnum.UN_WRITE_OFF.getValue().equals(deliveryInstead.getWriteoffFlag())) {
                throw new CommonException(MessageFormat.format("{}\u51ed\u8bc1{}\u884c\u5df2\u51b2\u9500\uff0c\u8bf7\u5237\u65b0", deliveryInstead.getInsteadVoucherNo(), deliveryInstead.getInsteadVoucherItemNo()));
            }
            if (OemReceivingStatusEnum.UNRECEIVE.getValue() != deliveryInstead.getReceivingStatus().intValue()) {
                throw new CommonException(MessageFormat.format("{}\u51ed\u8bc1{}\u884c\u5df2\u6536\u8d27\uff0c\u8bf7\u5237\u65b0", deliveryInstead.getInsteadVoucherNo(), deliveryInstead.getInsteadVoucherItemNo()));
            }
            this.buildInstead((OemReceivingInstead)instead, deliveryInstead);
        });
    }

    private void buildInstead(OemReceivingInstead instead, OemDeliveryInstead deliveryInstead) {
        instead.setId(UUIDGenerator.generateUUID());
        instead.setReceivingVoucherNo(GetVoucherNoUtil.getOemReceivingVoucher(deliveryInstead.getReceivingFactory()));
        instead.setReceivingVoucherItemNo("1");
        instead.setDeliveryVoucherNo(deliveryInstead.getInsteadVoucherNo());
        instead.setDeliveryVoucherItemNo(deliveryInstead.getInsteadVoucherItemNo());
        instead.setDeliverySapVoucherNo(deliveryInstead.getSapVoucherNo());
        instead.setDeliverySapVoucherItemNo(deliveryInstead.getSapVoucherItemNo());
        instead.setDeliveryMoveType(deliveryInstead.getMoveType());
        instead.setDeliveryQuantity(deliveryInstead.getDeliveryQuantity());
        instead.setDeliveryBatchNo(deliveryInstead.getDeliveryBatchNo());
        instead.setMaterialId(deliveryInstead.getMaterialId());
        instead.setMaterialCode(deliveryInstead.getMaterialCode());
        instead.setMaterialName(deliveryInstead.getMaterialName());
        instead.setDeliveryOrderId(deliveryInstead.getDeliveryOrderId());
        instead.setDeliveryOrderNo(deliveryInstead.getDeliveryOrderNo());
        instead.setDeliveryOrderItemId(deliveryInstead.getDeliveryOrderItemId());
        instead.setDeliveryOrderItemNo(deliveryInstead.getDeliveryOrderItemNo());
        instead.setDeliveryRemarks(deliveryInstead.getDeliveryRemarks());
        instead.setQuantity(deliveryInstead.getQuantity());
        instead.setUnit(deliveryInstead.getUnit());
        instead.setExpectDeliveryTime(deliveryInstead.getExpectDeliveryTime());
        instead.setExpectArriveTime(deliveryInstead.getExpectArriveTime());
        instead.setDeliveryFactory(deliveryInstead.getDeliveryFactory());
        instead.setDeliveryFactoryName(deliveryInstead.getDeliveryFactoryName());
        instead.setDeliveryStorehouse(deliveryInstead.getDeliveryStorehouse());
        instead.setDeliveryStorehouseDesc(deliveryInstead.getDeliveryStorehouseDesc());
        instead.setDeliveryCompanyId(deliveryInstead.getDeliveryCompanyId());
        instead.setDeliveryCompanySapCode(deliveryInstead.getDeliveryCompanySapCode());
        instead.setDeliveryCompanySrmCode(deliveryInstead.getDeliveryCompanySrmCode());
        instead.setDeliveryCompanyName(deliveryInstead.getDeliveryCompanyName());
        instead.setAllotOrderType(deliveryInstead.getAllotOrderType());
        instead.setReceivingFactory(deliveryInstead.getReceivingFactory());
        instead.setReceivingFactoryName(deliveryInstead.getReceivingFactoryName());
        instead.setReceivingStorehouse(deliveryInstead.getReceivingStorehouse());
        instead.setReceivingStorehouseDesc(deliveryInstead.getReceivingStorehouseDesc());
        instead.setReceivingCompanyId(deliveryInstead.getReceivingCompanyId());
        instead.setReceivingCompanySapCode(deliveryInstead.getReceivingCompanySapCode());
        instead.setReceivingCompanySrmCode(deliveryInstead.getReceivingCompanySrmCode());
        instead.setReceivingCompanyName(deliveryInstead.getReceivingCompanyName());
        instead.setTransferOrderNo(deliveryInstead.getTransferOrderNo());
        instead.setTransferOrderItemNo(deliveryInstead.getTransferOrderItemNo());
        instead.setCreateTime(new Date());
        instead.setCreateUserId(this.getSupUser().getId());
        instead.setCreateUserName(this.getSupUser().getNickName());
        instead.setConfirmStatus(OemConfirmStatusEnum.UNCOLLECTED.getValue());
        instead.setWriteoffFlag(OemWriteOffEnum.UN_WRITE_OFF.getValue());
    }

    private void vaild(List<OemReceivingInstead> insteads) {
        insteads.stream().forEach(instead -> Assert.isNotBlank((String)instead.getDeliveryVoucherId(), (String)"\u53d1\u8d27ID\u4e3a\u7a7a"));
    }
}

