/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.receiving.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.liby.delivery.entity.OemDeliveryInstead;
import com.els.liby.receiving.entity.OemReceivingInstead;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemReceivingStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class ModifyReceivingInsteadCommand
extends AbstractCommand {
    private List<OemReceivingInstead> insteads;

    public ModifyReceivingInsteadCommand(List<OemReceivingInstead> insteads) {
        this.insteads = insteads;
    }

    public Object execute(ICommandInvoker context) {
        this.vaild(this.insteads);
        List<OemReceivingInstead> list = this.init(this.insteads);
        list.stream().forEach(instead -> OemContextUtils.getOemReceivingInsteadService().modifyObj((Serializable)instead));
        this.updateReceivingStatusByDeliveryInsteadId(this.insteads);
        return null;
    }

    private void updateReceivingStatusByDeliveryInsteadId(List<OemReceivingInstead> insteads) {
        List<String> deliveryInsteadIds = insteads.stream().map(i -> i.getDeliveryVoucherId()).collect(Collectors.toList());
        OemContextUtils.getOemDeliveryInsteadService().modifyReceivingStatusbyids(OemReceivingStatusEnum.RECEIVEING.getValue(), deliveryInsteadIds);
    }

    private List<OemReceivingInstead> init(List<OemReceivingInstead> insteads) {
        List<OemReceivingInstead> list = insteads.stream().map(instead -> {
            OemReceivingInstead oemReceivingInstead = new OemReceivingInstead();
            oemReceivingInstead.setId(instead.getId());
            oemReceivingInstead.setReceivingDate(instead.getReceivingDate());
            oemReceivingInstead.setReceivingRemarks(instead.getReceivingRemarks());
            oemReceivingInstead.setUpdateTime(new Date());
            oemReceivingInstead.setUpdateUserId(this.getSupUser().getId());
            oemReceivingInstead.setUpdateUserName(this.getSupUser().getNickName());
            oemReceivingInstead.setConfirmStatus(OemConfirmStatusEnum.RETURN_BACK.getValue());
            return oemReceivingInstead;
        }).collect(Collectors.toList());
        return list;
    }

    private void vaild(List<OemReceivingInstead> insteads) {
        insteads.stream().forEach(instead -> {
            Assert.isNotBlank((String)instead.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
            OemDeliveryInstead deliveryInstead = (OemDeliveryInstead)OemContextUtils.getOemDeliveryInsteadService().queryObjById(instead.getDeliveryVoucherId());
            if (!OemWriteOffEnum.UN_WRITE_OFF.getValue().equals(deliveryInstead.getWriteoffFlag())) {
                throw new CommonException(MessageFormat.format("\u4ee3\u53d1\u8d27\uff1a{0}\u51ed\u8bc1\uff0c{1}\u884c\u5df2\u51b2\u9500\uff0c\u8bf7\u5237\u65b0", deliveryInstead.getInsteadVoucherNo(), deliveryInstead.getInsteadVoucherItemNo()));
            }
            if (OemReceivingStatusEnum.UNRECEIVE.getValue() != deliveryInstead.getReceivingStatus().intValue()) {
                throw new CommonException(MessageFormat.format("\u4ee3\u53d1\u8d27\uff1a{0}\u51ed\u8bc1\uff0c{1}\u884c\u5df2\u6536\u8d27\uff0c\u8bf7\u5237\u65b0", deliveryInstead.getInsteadVoucherNo(), deliveryInstead.getInsteadVoucherItemNo()));
            }
            OemReceivingInstead receiving = (OemReceivingInstead)OemContextUtils.getOemReceivingInsteadService().queryObjById(instead.getId());
            if (receiving.getConfirmStatus().equals(OemConfirmStatusEnum.COLLECTED.getValue())) {
                throw new CommonException(MessageFormat.format("{0}\u4ee3\u6536\u8d27\u51ed\u8bc1\uff0c{1}\u884c\u5df2\u786e\u8ba4", receiving.getReceivingVoucherNo(), receiving.getReceivingVoucherItemNo()));
            }
            if (!receiving.getWriteoffFlag().equals(OemWriteOffEnum.UN_WRITE_OFF.getValue())) {
                throw new CommonException(MessageFormat.format("{0}\u4ee3\u6536\u8d27\u51ed\u8bc1\uff0c{1}\u884c\u5df2\u51b2\u9500", receiving.getReceivingVoucherNo(), receiving.getReceivingVoucherItemNo()));
            }
        });
    }
}

