/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.receiving.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.delivery.entity.PurVoucher;
import com.els.liby.collection.utils.OemOrderItemUtils;
import com.els.liby.receiving.entity.OemReceivingInstead;
import com.els.liby.receiving.entity.OemReceivingInsteadExample;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemReceivingStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ReceivingWriteOffByAspCommand
extends AbstractCommand {
    private Date startTime;
    private Date endTime;

    public ReceivingWriteOffByAspCommand(Date startTime, Date endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Object execute(ICommandInvoker context) {
        List<PurVoucher> purVouchers = OemOrderItemUtils.getSapWriteOffVoucherNos(this.startTime, this.endTime);
        for (PurVoucher voucher : purVouchers) {
            this.writeOffFeed(voucher);
        }
        return null;
    }

    private void writeOffFeed(PurVoucher voucher) {
        if (StringUtils.isBlank((String)voucher.getMaterialVoucherNo())) {
            return;
        }
        OemReceivingInsteadExample example = new OemReceivingInsteadExample();
        example.createCriteria().andReceivingSapVoucherNoEqualTo(voucher.getMaterialVoucherNo());
        List list = OemContextUtils.getOemReceivingInsteadService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        OemReceivingInstead instead = new OemReceivingInstead();
        instead.setWriteoffFlag(OemWriteOffEnum.SAP_WRITE_OFF.getValue());
        instead.setWriteoffDate(voucher.getVoucherTime());
        OemContextUtils.getOemReceivingInsteadService().modifybyExample(instead, example);
        this.updateReceivingStatusByDeliveryInsteadId(list);
    }

    private void updateReceivingStatusByDeliveryInsteadId(List<OemReceivingInstead> insteads) {
        List<String> deliveryInsteadIds = insteads.stream().map(i -> i.getDeliveryVoucherId()).distinct().collect(Collectors.toList());
        OemContextUtils.getOemDeliveryInsteadService().modifyReceivingStatusbyids(OemReceivingStatusEnum.UNRECEIVE.getValue(), deliveryInsteadIds);
    }
}

