/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.receiving.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.liby.receiving.entity.OemReceivingInstead;
import com.els.liby.receiving.entity.OemReceivingInsteadExample;
import com.els.liby.util.OemConfirmStatusEnum;
import com.els.liby.util.OemContextUtils;
import com.els.liby.util.OemReceivingStatusEnum;
import com.els.liby.util.OemWriteOffEnum;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class WriteOffCommand
extends AbstractCommand {
    private List<OemReceivingInstead> oemReceivingInsteads;

    public WriteOffCommand(List<OemReceivingInstead> oemReceivingInsteads) {
        this.oemReceivingInsteads = oemReceivingInsteads;
    }

    public Object execute(ICommandInvoker context) {
        this.vaidStatus(this.oemReceivingInsteads);
        List ids = this.oemReceivingInsteads.stream().map(o -> o.getId()).collect(Collectors.toList());
        OemReceivingInsteadExample example = new OemReceivingInsteadExample();
        example.createCriteria().andIdIn(ids);
        OemReceivingInstead instead = new OemReceivingInstead();
        instead.setWriteoffFlag(OemWriteOffEnum.SRM_WRITE_OFF.getValue());
        instead.setWriteoffDate(new Date());
        instead.setWriteoffUserId(this.getSupUser().getId());
        instead.setWriteoffUserName(this.getSupUser().getNickName());
        OemContextUtils.getOemReceivingInsteadService().modifybyExample(instead, example);
        this.updateReceivingStatusByDeliveryInsteadId(this.oemReceivingInsteads);
        return null;
    }

    private void updateReceivingStatusByDeliveryInsteadId(List<OemReceivingInstead> insteads) {
        List<String> deliveryInsteadIds = insteads.stream().map(i -> i.getDeliveryVoucherId()).collect(Collectors.toList());
        OemContextUtils.getOemDeliveryInsteadService().modifyReceivingStatusbyids(OemReceivingStatusEnum.UNRECEIVE.getValue(), deliveryInsteadIds);
    }

    private void vaidStatus(List<OemReceivingInstead> oemReceivingInsteads) {
        oemReceivingInsteads.stream().forEach(o -> {
            if (OemConfirmStatusEnum.COLLECTED.getValue() == o.getConfirmStatus().intValue()) {
                throw new CommonException("\u51b2\u9500\u5931\u8d25\uff1b\u4ee3\u53d1\u8d27\u51ed\u8bc1\u53f7\uff1a" + o.getReceivingVoucherNo() + "\uff1b\u5df2\u786e\u8ba4");
            }
            if (!OemWriteOffEnum.UN_WRITE_OFF.getValue().equals(o.getWriteoffFlag())) {
                throw new CommonException("\u51b2\u9500\u5931\u8d25\uff1b\u4ee3\u6536\u51ed\u8bc1\u53f7\uff1a" + o.getReceivingVoucherNo() + "\uff1b\u5df2\u51b2\u9500");
            }
        });
    }
}

