/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.receiving.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.receiving.dao.OemReceivingInsteadMapper;
import com.els.liby.receiving.entity.OemReceivingInstead;
import com.els.liby.receiving.entity.OemReceivingInsteadExample;
import com.els.liby.receiving.service.OemReceivingInsteadService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOemReceivingInsteadService")
public class OemReceivingInsteadServiceImpl
implements OemReceivingInsteadService {
    @Resource
    protected OemReceivingInsteadMapper oemReceivingInsteadMapper;

    @CacheEvict(value={"oemReceivingInstead"}, allEntries=true)
    public void addObj(OemReceivingInstead t) {
        this.oemReceivingInsteadMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"oemReceivingInstead"}, allEntries=true)
    public void addAll(List<OemReceivingInstead> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.oemReceivingInsteadMapper.insertBatch(list);
    }

    @CacheEvict(value={"oemReceivingInstead"}, allEntries=true)
    public void deleteObjById(String id) {
        this.oemReceivingInsteadMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"oemReceivingInstead"}, allEntries=true)
    public void deleteByExample(OemReceivingInsteadExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.oemReceivingInsteadMapper.deleteByExample(example);
    }

    @CacheEvict(value={"oemReceivingInstead"}, allEntries=true)
    public void modifyObj(OemReceivingInstead t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.oemReceivingInsteadMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"oemReceivingInstead"}, keyGenerator="redisKeyGenerator")
    public OemReceivingInstead queryObjById(String id) {
        return this.oemReceivingInsteadMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"oemReceivingInstead"}, keyGenerator="redisKeyGenerator")
    public List<OemReceivingInstead> queryAllObjByExample(OemReceivingInsteadExample example) {
        return this.oemReceivingInsteadMapper.selectByExample(example);
    }

    @Cacheable(value={"oemReceivingInstead"}, keyGenerator="redisKeyGenerator")
    public PageView<OemReceivingInstead> queryObjByPage(OemReceivingInsteadExample example) {
        PageView<OemReceivingInstead> pageView = example.getPageView();
        pageView.setQueryResult(this.oemReceivingInsteadMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"oemReceivingInstead"}, allEntries=true)
    public void modifybyExample(OemReceivingInstead instead, OemReceivingInsteadExample example) {
        this.oemReceivingInsteadMapper.updateByExampleSelective(instead, example);
    }
}

