/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.util;

import com.els.base.core.exception.CommonException;
import com.els.liby.quota.service.SoapServiceRequestText;
import com.els.liby.sap.ZSRMRFCDELIVERYCONResponse;
import com.els.liby.util.OemSapConfUtils;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OemDeliveryBackSapUtil {
    private static final Logger log = LoggerFactory.getLogger(OemDeliveryBackSapUtil.class);
    private static String username = OemSapConfUtils.getServiceUsername();
    private static String password = OemSapConfUtils.getServicePassword();
    private static String serviceUrl = OemSapConfUtils.getOemDeliveryConUrl();
    private static String serviceNameSpace = OemSapConfUtils.getNameSpace();
    private static String serviceMethod = OemSapConfUtils.getOemDeliveryConServiceMethod();

    public static ZSRMRFCDELIVERYCONResponse backToSap(String xmlParams) {
        return OemDeliveryBackSapUtil.getDataFromSap(xmlParams);
    }

    private static ZSRMRFCDELIVERYCONResponse getDataFromSap(String xmlParams) {
        log.debug("\u3010OEM\u6536/\u53d1\u786e\u8ba4\u56de\u5199SAP\u3011serviceUrl\u4e3a[{}]", (Object)serviceUrl);
        SoapServiceRequestText request = new SoapServiceRequestText();
        request.setUrl(serviceUrl);
        if (StringUtils.isNotBlank((String)serviceNameSpace)) {
            request.setNamespace(serviceNameSpace);
        }
        if (!StringUtils.isEmpty((String)username)) {
            String src = username.trim() + ":" + password.trim();
            String encoding = new String(Base64.encodeBase64((byte[])src.getBytes()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + encoding);
            request.addHeaders(headers);
        }
        request.setMethodName(serviceMethod);
        request.setXmlParams(xmlParams);
        log.debug("\u3010OEM\u6536/\u53d1\u786e\u8ba4\u56de\u5199SAP\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a[{0}]", (Object)xmlParams);
        log.debug("\u3010OEM\u6536/\u53d1\u786e\u8ba4\u56de\u5199SAP\u3011\u5f00\u59cb\u8c03\u7528sap\u63a5\u53e3");
        long startTime = System.currentTimeMillis();
        HttpCallbackResultVO vo = request.execute(ZSRMRFCDELIVERYCONResponse.class);
        long endTime = System.currentTimeMillis();
        log.debug("\u3010OEM\u6536/\u53d1\u8d27\u786e\u8ba4\u56de\u5199SAP\u3011\u7ed3\u675f\u8c03\u7528sap\u63a5\u53e3,\u7528\u65f6\u4e3a[{1}]", (Object)(endTime - startTime));
        if (vo.getStatus() < 200 || vo.getStatus() > 299) {
            throw new CommonException("OEM\u6536/\u53d1\u786e\u8ba4\u56de\u5199SAP\u63a5\u53e3\u5f02\u5e38");
        }
        log.debug("\u3010OEM\u6536/\u53d1\u786e\u8ba4\u56de\u5199SAP\u3011\u8fd4\u56de\u7ed3\u679c\u4e3a", vo.getResult());
        ZSRMRFCDELIVERYCONResponse respone = (ZSRMRFCDELIVERYCONResponse)vo.getResult();
        if (respone == null) {
            throw new CommonException("\u3010OEM\u6536/\u53d1\u786e\u8ba4\u56de\u5199SAP\u3011,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        log.info("\u3010OEM\u6536/\u53d1\u786e\u8ba4\u56de\u5199SAP\u30111.\u83b7\u53d6\u5230\u6570\u636e");
        return respone;
    }
}

