/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.rpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.service.AiChatDataLoaderRpcService;
import com.els.modules.system.util.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="v5AiChatDataLoaderRpcServiceImpl")
public class V5AiChatDataLoaderRpcServiceImpl
implements AiChatDataLoaderRpcService {
    private static final Logger log = LoggerFactory.getLogger(V5AiChatDataLoaderRpcServiceImpl.class);
    @Value(value="${els.config.service.srm-address}")
    public String srmAddress;
    public static final String RESULT_STR = "result";
    private static final String SRM_ORDER_AI_LOAD_SCHEMA_DATA = "/aiToSrm/loadSchemaData";

    public Map<String, String> buildMapHeaders(Map<String, String> headers) {
        String token;
        if (null == headers) {
            headers = new HashMap<String, String>();
        }
        if (StringUtils.isEmpty((CharSequence)(token = SpringContextUtils.getHttpServletRequest().getHeader("X-Access-Token")))) {
            token = SpringContextUtils.getHttpServletRequest().getHeader("srmToken");
        }
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.put("X-Access-Token", token);
        }
        headers.put("Content-Type", "application/json");
        String language = SpringContextUtils.getHttpServletRequest().getHeader("language");
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            headers.put("language", language);
        }
        String userAgent = SpringContextUtils.getHttpServletRequest().getHeader("user-agent");
        headers.put("user-agent", userAgent);
        return headers;
    }

    public JSONObject sendHttp(String url, String methodCode, JSONObject requestBody) {
        try {
            JSONObject body;
            Map<String, String> mapHeaders = this.buildMapHeaders(new HashMap<String, String>());
            if (url.contains("noToken")) {
                mapHeaders.remove("X-Access-Token");
            }
            if (null == (body = HttpUtils.post(this.srmAddress + url + "/" + methodCode, requestBody, mapHeaders, JSONObject.class)) || !body.containsKey((Object)"success") || !"true".equals(body.getString("success"))) {
                throw new RuntimeException("SRM\u8bf7\u6c42" + this.srmAddress + "\u7cfb\u7edf\u62a5\u9519:" + body.getString("message"));
            }
            return body;
        }
        catch (Exception e) {
            log.error("http error:{}", (Object)e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public Map<String, String> loadSchemaData(JSONObject param, String ... args) {
        JSONObject result = this.sendHttp(SRM_ORDER_AI_LOAD_SCHEMA_DATA, args[0], param);
        return (Map)result.toJavaObject(Map.class);
    }
}

