/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.entity.PermissionGroup;
import com.els.modules.system.entity.PermissionSensitiveField;
import com.els.modules.system.entity.UserPermissionGroup;
import com.els.modules.system.mapper.PermissionGroupMapper;
import com.els.modules.system.mapper.PermissionSensitiveFieldMapper;
import com.els.modules.system.mapper.UserPermissionGroupMapper;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.service.PermissionGroupService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionGroupServiceImpl
extends BaseServiceImpl<PermissionGroupMapper, PermissionGroup>
implements PermissionGroupService {
    public static final String PERMISSION_GROUP_DATA_KEY = "sys:permissionData:group:";
    public static final String PERMISSION_SENSITIVE_FIELD_KEY = "sys:sensitiveField:group:";
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private UserPermissionGroupMapper userPermissionGroupMapper;
    @Resource
    private PermissionDataService permissionDataService;
    @Resource
    private PermissionSensitiveFieldMapper permissionSensitiveFieldMapper;

    @Override
    public List<PermissionData> getPermissionDatasByUserId(String userId) {
        List dataList = (ArrayList)this.redisUtil.get(PERMISSION_GROUP_DATA_KEY + userId);
        if (dataList == null) {
            dataList = new ArrayList();
            List groupIdList = this.userPermissionGroupMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).stream().map(UserPermissionGroup::getGroupId).collect(Collectors.toList());
            if (!groupIdList.isEmpty()) {
                dataList = this.permissionDataService.list((Wrapper)new QueryWrapper().in((Object)"group_id", groupIdList));
            }
            this.redisUtil.set(PERMISSION_GROUP_DATA_KEY + userId, dataList);
        }
        return dataList;
    }

    @Override
    public List<PermissionData> getPermissionDatasByUserIdAndBusinessType(String userId, String businessType) {
        List<PermissionData> dataList = this.getPermissionDatasByUserId(userId);
        List<PermissionData> resultList = dataList.parallelStream().filter(data -> data.getBusinessType().equals(businessType) || "all".equals(data.getBusinessType())).collect(Collectors.toList());
        return resultList;
    }

    @Override
    public List<PermissionSensitiveField> getSensitiveFieldByUserId(String userId) {
        List dataList = (ArrayList)this.redisUtil.get(PERMISSION_SENSITIVE_FIELD_KEY + userId);
        if (dataList == null) {
            dataList = new ArrayList();
            List groupIdList = this.userPermissionGroupMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).stream().map(UserPermissionGroup::getGroupId).collect(Collectors.toList());
            if (!groupIdList.isEmpty()) {
                dataList = this.permissionSensitiveFieldMapper.selectList((Wrapper)new QueryWrapper().in((Object)"group_id", groupIdList));
            }
            this.redisUtil.set(PERMISSION_SENSITIVE_FIELD_KEY + userId, dataList);
        }
        return dataList;
    }

    @Override
    public List<PermissionSensitiveField> getSensitiveFieldByUserIdAndBusinessType(String userId, String businessType) {
        List<PermissionSensitiveField> dataList = this.getSensitiveFieldByUserId(userId);
        List<PermissionSensitiveField> resultList = dataList.parallelStream().filter(data -> data.getBusinessType().equals(businessType) || "all".equals(data.getBusinessType())).collect(Collectors.toList());
        return resultList;
    }
}

