/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static final OkHttpClient client = new OkHttpClient.Builder().readTimeout(3L, TimeUnit.MINUTES).retryOnConnectionFailure(true).build();

    public static Response execute(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        return client.newCall(request).execute();
    }

    public static String get(String url) throws IOException {
        return HttpUtils.doRequest(HttpUtils.builder(url).build());
    }

    public static String get(String url, Map<String, String> headers) throws IOException {
        return HttpUtils.doRequest(HttpUtils.headerBuilder(url, headers).build());
    }

    public static String get(String url, Map<String, String> headers, Map<String, Object> params) throws IOException {
        return HttpUtils.doRequest(HttpUtils.headerBuilder(url + HttpUtils.buildUrlParams(params), headers).build());
    }

    public static <T> T get(String url, Class<T> classOfT) throws IOException {
        return HttpUtils.doRequest(HttpUtils.builder(url).build(), classOfT);
    }

    public static <T> T get(String url, Map<String, String> headers, Class<T> classOfT) throws IOException {
        return HttpUtils.doRequest(HttpUtils.headerBuilder(url, headers).build(), classOfT);
    }

    public static <T> T get(String url, Map<String, String> headers, Map<String, Object> params, Class<T> classOfT) throws IOException {
        return HttpUtils.doRequest(HttpUtils.headerBuilder(url + HttpUtils.buildUrlParams(params), headers).build(), classOfT);
    }

    public static String post(String url, Object body) throws IOException {
        return HttpUtils.doRequest(HttpUtils.postRequest(url, body));
    }

    public static String post(String url, Object body, Map<String, String> headers) throws IOException {
        return HttpUtils.doRequest(HttpUtils.postRequest(url, body, headers));
    }

    public static <T> T post(String url, Object body, Class<T> classOfT) throws IOException {
        return HttpUtils.doRequest(HttpUtils.postRequest(url, body), classOfT);
    }

    public static <T> T post(String url, Object body, Map<String, String> headers, Class<T> classOfT) throws IOException {
        return HttpUtils.doRequest(HttpUtils.postRequest(url, body, headers), classOfT);
    }

    private static Request postRequest(String url, Object body) {
        return HttpUtils.builder(url).post(HttpUtils.buildRequestBody(body, null)).build();
    }

    private static Request postRequest(String url, Object body, Map<String, String> headers) {
        return HttpUtils.headerBuilder(url, headers).post(HttpUtils.buildRequestBody(body, headers)).build();
    }

    private static Request.Builder builder(String url) {
        return new Request.Builder().url(url);
    }

    private static Request.Builder headerBuilder(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder().url(url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        return builder;
    }

    private static <T> T doRequest(Request request, Class<T> classOfT) throws IOException {
        return (T)JSON.parseObject((String)HttpUtils.doRequest(request), classOfT);
    }

    private static String doRequest(Request request) throws IOException {
        long beginTime = System.currentTimeMillis();
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        throw new RuntimeException("Http\u8bf7\u6c42\u5931\u8d25[" + response.code() + "]:" + response.body().string() + "...");
    }

    private static RequestBody buildRequestBody(Object body, Map<String, String> headers) {
        if (headers != null && headers.containsKey("Content-Type")) {
            String contentType = headers.get("Content-Type");
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)body.toString());
        }
        if (body instanceof String && ((String)body).contains("=")) {
            return RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (String)((String)body));
        }
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)JSON.toJSONString((Object)body));
    }

    private static String buildUrlParams(Map<String, Object> params) {
        if (params.isEmpty()) {
            return "";
        }
        return "?" + params.entrySet().stream().map(it -> (String)it.getKey() + "=" + it.getValue()).collect(Collectors.joining("&"));
    }

    static {
        Dispatcher dispatcher = client.dispatcher();
        dispatcher.setMaxRequestsPerHost(300);
        dispatcher.setMaxRequests(200);
    }
}

