/*
 * Decompiled with CFR 0.152.
 */
package com.els.rpc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.els.common.exception.ELSBootException;
import com.els.common.system.api.CommonAPI;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.InterfaceAppDTO;
import com.els.modules.account.api.dto.JustAuthConfigDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.dto.PermissionDataDTO;
import com.els.modules.account.api.dto.PermissionSensitiveFieldDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.dto.SubAccountOrgDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.account.api.dto.ThirdAuthDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.entity.PermissionSensitiveField;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.service.PermissionGroupService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.SubaccountOrgService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="coreInvokeAccountServiceImpl")
public class CoreInvokeAccountBeanServiceImpl
implements InvokeAccountRpcService {
    @Lazy
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private PermissionService permissionService;
    @Resource
    private CommonAPI sysBaseApi;
    @Resource
    private PermissionDataService permissionDataService;
    @Resource
    private SubaccountOrgService subaccountOrgService;
    @Resource
    private PermissionGroupService permissionGroupService;

    public LoginUserDTO getLoginUser(String account) {
        LoginUser loginUser = this.sysBaseApi.getUserByAccount(account);
        if (loginUser == null) {
            return null;
        }
        LoginUserDTO loginUserDTO = new LoginUserDTO();
        BeanUtils.copyProperties((Object)loginUser, (Object)loginUserDTO);
        return loginUserDTO;
    }

    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        return this.elsSubAccountService.getUserRolesSet(elsAccount, subAccount);
    }

    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        return this.elsSubAccountService.getUserPermissionsSet(elsAccount, subAccount);
    }

    public Set<String> getAllOptPermission() {
        return this.permissionService.getAllOptPermission();
    }

    public List<PermissionDataDTO> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        List<PermissionData> dataList = this.permissionDataService.getPermissionDataList(elsAccount, subAccount, businessType);
        ArrayList<PermissionDataDTO> resultList = new ArrayList<PermissionDataDTO>();
        for (PermissionData data : dataList) {
            PermissionDataDTO dataDTO = new PermissionDataDTO();
            BeanUtils.copyProperties((Object)((Object)data), (Object)dataDTO);
            resultList.add(dataDTO);
        }
        return resultList;
    }

    public List<String> getAccountListByLeader(String elsAccount, String subAccount) {
        return this.elsSubAccountService.getAccountListByLeader(elsAccount, subAccount);
    }

    public List<PermissionDataDTO> getPermissionDataList(String userId, String businessType) {
        List<PermissionData> dataList = this.permissionGroupService.getPermissionDatasByUserIdAndBusinessType(userId, businessType);
        return SysUtil.copyProperties(dataList, PermissionDataDTO.class);
    }

    public Map<String, String> getUserOrg(String userId) {
        return this.subaccountOrgService.getUserOrg(userId);
    }

    public List<PermissionSensitiveFieldDTO> getPermissionSensitiveFieldList(String userId, String businessType) {
        List<PermissionSensitiveField> fieldList = this.permissionGroupService.getSensitiveFieldByUserIdAndBusinessType(userId, businessType);
        return SysUtil.copyProperties(fieldList, PermissionSensitiveFieldDTO.class);
    }

    public List<ThirdAccountDTO> getThirdAccount(String accountId, String thirdType) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<PersonalSettingDTO> getPersonalSetting(String elsAccount, String subAccount) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public ElsSubAccountDTO getAccount(String elsAccount, String subAccount) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public ElsSubAccountDTO getAccountById(String id) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<ElsSubAccountDTO> getAccountById(List<String> ids) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<ElsSubAccountDTO> getAccountByRoles(String elsAccount, List<String> roles) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<ElsSubAccountDTO> getAccountByGroups(String elsAccount, List<String> orgs, String orgCategoryCode) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<ElsSubAccountDTO> getAccountList(String elsAccount, List<String> subAccounts) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public ElsEnterpriseInfoDTO getByElsAccount(String elsAccount) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public ThirdAuthDTO getThirdAuthByType(String elsAccount, String appType) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public JSONArray getMenuJsonArray(String elsAccount, String subAccount, Integer mobile) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public JustAuthConfigDTO getOneConfig(String elsAccount, String authType) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<ElsTenantDTO> getTenantList(List<String> elsAccounts) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<String> queryAllSubAccount(List<String> elsAccount) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<SubAccountOrgDTO> getSubAccountOrgList(String userId) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public InterfaceAppDTO getApp(String appKey, String appSecret) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public Boolean checkAppPermission(String elsAccount, String appId, String interfaceCode) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<PermissionDTO> getPermissionByAccount(String elsAccount, String subAccount) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }
}

