/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.aspect;

import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Aspect
@Component
public class SrmTransactionAspect {
    @Resource
    private PlatformTransactionManager txManager;

    @Pointcut(value="@annotation(com.els.common.aspect.annotation.SrmTransaction)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object object;
        DefaultTransactionDefinition dtd = new DefaultTransactionDefinition();
        dtd.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)dtd);
        try {
            object = point.proceed();
        }
        catch (Throwable e) {
            this.txManager.rollback(status);
            throw e;
        }
        this.txManager.commit(status);
        return object;
    }
}

