/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.service.SrmToIPaasService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SrmToIPaasServiceImpl
implements SrmToIPaasService {
    private static final Logger log = LoggerFactory.getLogger(SrmToIPaasServiceImpl.class);
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String url = this.configMap.get("url");
    private String elsAccount = this.configMap.get("elsAccount");
    private String subAccount = this.configMap.get("subAccount");
    private String pwd = this.configMap.get("pwd");
    private String[] currentAccountServices = new String[]{"createOrder", "orderList", "confirmOrder", "cancelOrder", "orderDetail", "qualificationList", "expensesList", "getAmount", "commonPayService", "orderPayment", "commonPaySearch"};

    @Override
    public JSONObject callIPaasInterface(JSONObject data, String service) {
        return this.callIPaasInterface(data, service, null);
    }

    @Override
    public JSONObject callIPaasInterface(JSONObject data, String service, String interfaceCode) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("elsAccount", this.elsAccount);
        header.put("subAccount", this.subAccount);
        header.put("pwd", this.pwd);
        JSONObject body = new JSONObject();
        String currentAccount = data.getString("currentAccount");
        if (StrUtil.isBlank((CharSequence)currentAccount)) {
            currentAccount = TenantContext.getTenant();
        }
        if (Arrays.asList(this.currentAccountServices).contains(service)) {
            currentAccount = TenantContext.getTenant();
        }
        body.put("elsAccount", (Object)currentAccount);
        body.put("data", (Object)data);
        body.put("service", (Object)service);
        if (StrUtil.isNotBlank((CharSequence)interfaceCode)) {
            body.put("interfaceCode", (Object)interfaceCode);
        }
        try {
            String response = ((HttpRequest)HttpRequest.post((String)this.url).addHeaders(header)).body(body.toString()).execute().body();
            JSONObject responseObj = JSONObject.parseObject((String)response);
            if (!responseObj.getBoolean("success").booleanValue()) {
                return this.getErrorObj(responseObj.getString("message"));
            }
            String message = responseObj.getString("message");
            JSONObject returnData = responseObj.getJSONObject("result");
            return returnData == null ? this.getOkObj(message) : this.getOkObj(returnData);
        }
        catch (Exception e) {
            log.error("iPaas\u63a5\u53e3\u8c03\u7528\u5931\u8d25:", (Throwable)e);
            return this.getErrorObj(e.getMessage());
        }
    }

    private JSONObject getErrorObj(String message) {
        JSONObject result = new JSONObject();
        result.put("success", (Object)false);
        result.put("code", (Object)CommonConstant.SC_INTERNAL_SERVER_ERROR_500);
        result.put("message", (Object)message);
        return result;
    }

    private JSONObject getOkObj(String message) {
        JSONObject result = new JSONObject();
        result.put("success", (Object)true);
        result.put("code", (Object)CommonConstant.SC_OK_200);
        result.put("message", (Object)message);
        return result;
    }

    private JSONObject getOkObj(JSONObject data) {
        JSONObject result = new JSONObject();
        result.put("success", (Object)true);
        result.put("code", (Object)CommonConstant.SC_OK_200);
        result.put("data", (Object)data);
        return result;
    }
}

