/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.api.CommonAPI;
import com.els.common.system.vo.ComboModel;
import com.els.common.system.vo.DictModel;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionGroup;
import com.els.modules.system.entity.UserPermissionGroup;
import com.els.modules.system.mapper.ElsCompanySetMapper;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.UserPermissionGroupMapper;
import com.els.modules.system.service.PermissionGroupService;
import com.els.modules.system.vo.ElsCompanySetVO;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BaseApiImpl
implements CommonAPI {
    private static final Logger log = LoggerFactory.getLogger(BaseApiImpl.class);
    @Resource
    private ElsSubAccountMapper userMapper;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private ElsCompanySetMapper elsCompanySetMapper;
    @Resource
    private UserPermissionGroupMapper userPermissionGroupMapper;
    @Resource
    private PermissionGroupService permissionGroupService;

    public LoginUser getUserByAccount(String account) {
        if (ConvertUtils.isEmpty((Object)account)) {
            return null;
        }
        String redisKey = String.format("%s::%s", "sys:cache:user", account);
        LoginUser user = (LoginUser)this.redisUtil.get(redisKey);
        if (user != null) {
            return user;
        }
        LoginUser loginUser = new LoginUser();
        ElsSubAccount sysUser = this.userMapper.getUserByAccount(account);
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)((Object)sysUser), (Object)loginUser);
        try {
            Map<String, String> map = this.userMapper.getLogoSetByElsAccount(account.split("_")[0]);
            loginUser.setAliasName(map.get("alias"));
            loginUser.setEnterpriseName(map.get("name"));
            loginUser.setEnterpriseLogo(map.get("default_value") != null && "1".equals(map.get("default_value")) && map.get("enterprise_logo") != null ? map.get("enterprise_logo") : "");
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        try {
            List<ElsCompanySetVO> companySetListVo = this.elsCompanySetMapper.findList(account.split("_")[0], SysUtil.getPurchaseAccount());
            List companySetList = Convert.toList(ElsCompanySetDTO.class, companySetListVo);
            JSONObject result = new JSONObject();
            for (ElsCompanySetDTO vo : companySetList) {
                result.put(vo.getItemCode(), (Object)vo.getDefaultValue());
            }
            loginUser.setCompanySet(result);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        List groupIdList = this.userPermissionGroupMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)loginUser.getId())).stream().map(UserPermissionGroup::getGroupId).collect(Collectors.toList());
        if (!groupIdList.isEmpty()) {
            String sensitiveFieldGroups = this.permissionGroupService.list((Wrapper)new QueryWrapper().in((Object)"id", groupIdList)).stream().map(PermissionGroup::getSensitiveFieldGroups).collect(Collectors.joining(","));
            loginUser.setSensitiveFieldGroups(sensitiveFieldGroups);
        }
        this.redisUtil.set(redisKey, (Object)loginUser, 1800L);
        return loginUser;
    }

    public void addLog(String logContent, Integer logType, Integer operatetype) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public LoginUser getUserById(String id) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<String> getRolesByUsername(String elsAccount, String subAccount) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public String getDatabaseType() throws SQLException {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<DictModel> queryDictItemsByCode(String code) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<DictModel> queryAllDict() {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<DictModel> queryTableDictItemsByCode(String table, String text, String code) throws Exception {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<DictModel> queryAllDepartBackDictModel() {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<DictModel> queryFilterTableDictInfo(String table, String text, String code, String filterSql) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<ComboModel> queryAllUser() {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<ComboModel> queryAllUser(String[] userIds) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<ComboModel> queryAllRole() {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<ComboModel> queryAllRole(String[] roleIds) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }

    public List<String> getRoleIdsByUsername(String elsAccount, String subAccount) {
        throw new ELSBootException("\u65e0\u9700\u5b9e\u73b0");
    }
}

