/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.mapper.DictMapper;
import com.els.modules.system.service.DictService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DictServiceImpl
extends ServiceImpl<DictMapper, Dict>
implements DictService {
    private static final Logger log = LoggerFactory.getLogger(DictServiceImpl.class);
    @Resource
    private DictMapper dictMapper;
    @Autowired
    private RedisUtil redisUtil;
    private static final String CATALOGUE = "sys:cache:dict";
    private static final String COLON = ":";

    @Override
    @Cacheable(value={"sys:cache:dict"}, key="#code+':text='+#text", sync=true)
    public String queryDictValueByText(String code, String text) {
        log.info("\u65e0\u7f13\u5b58dictText\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        String val = this.dictMapper.queryDictValueByText(code, text, TenantContext.getTenant());
        if (StringUtils.isBlank((String)val)) {
            val = this.dictMapper.queryDictValueByText(code, text, "100000");
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String queryTableDictItemsByValue(String table, String text, String code, String filterSql, String val, String elsAccountParam) {
        try {
            String elsAccount = StrUtil.isBlank((CharSequence)elsAccountParam) ? TenantContext.getTenant() : elsAccountParam;
            TenantContext.setTenant((String)elsAccount);
            StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(table).append(code).append(filterSql);
            String value = (String)this.redisUtil.get(redisKey.toString());
            if (StrUtil.isBlank((CharSequence)value)) {
                if (StrUtil.isBlank((CharSequence)filterSql)) {
                    filterSql = "1 = 1";
                }
                StringBuilder sql = new StringBuilder(filterSql);
                sql.append(" and is_deleted = '0'");
                if (!filterSql.contains("els_account") && !filterSql.contains("id =")) {
                    sql.append(" and els_account='").append(elsAccount).append("' ");
                }
                if (StrUtil.isBlank((CharSequence)(value = ((DictMapper)this.baseMapper).queryTableDictItemsByValue(table, code, sql.toString())))) {
                    sql = new StringBuilder(filterSql);
                    sql.append(" and is_deleted = '0'");
                    if (!filterSql.contains("els_account") && !filterSql.contains("id =")) {
                        sql.append(" and els_account='").append("100000").append("' ");
                    }
                    value = ((DictMapper)this.baseMapper).queryTableDictItemsByValue(table, code, sql.toString());
                }
                this.redisUtil.set(redisKey.toString(), (Object)value, 1800L);
            }
            String string = value;
            return string;
        }
        finally {
            TenantContext.clear();
        }
    }

    @Override
    public String queryTableDictItemTextsByValue(String table, String text, String code, String filterSql, String val, String elsAccount) {
        List<String> listText;
        String string = elsAccount = StrUtil.isBlank((CharSequence)elsAccount) ? TenantContext.getTenant() : elsAccount;
        if (StrUtil.isBlank((CharSequence)filterSql)) {
            filterSql = "1 = 1";
        }
        StringBuilder sql = new StringBuilder(filterSql);
        sql.append(" and is_deleted = '0'");
        if (!filterSql.contains("els_account") && !filterSql.contains("id =")) {
            sql.append(" and els_account='").append(elsAccount).append("' ");
        }
        if (CollectionUtil.isEmpty(listText = ((DictMapper)this.baseMapper).queryTableDictItemTextsByValue(table, text, sql.toString(), val)) && !SysUtil.getPurchaseAccount().equals(elsAccount) && !"100000".equals(elsAccount)) {
            sql = new StringBuilder(filterSql);
            sql.append(" and is_deleted = '0'");
            if (!filterSql.contains("els_account") && !filterSql.contains("id =")) {
                sql.append(" and els_account='").append(SysUtil.getPurchaseAccount()).append("' ");
            }
            listText = ((DictMapper)this.baseMapper).queryTableDictItemTextsByValue(table, text, sql.toString(), val);
        }
        if (CollectionUtil.isEmpty(listText)) {
            sql = new StringBuilder(filterSql);
            sql.append(" and is_deleted = '0'");
            if (!filterSql.contains("els_account") && !filterSql.contains("id =")) {
                sql.append(" and els_account='").append("100000").append("' ");
            }
            listText = ((DictMapper)this.baseMapper).queryTableDictItemTextsByValue(table, text, sql.toString(), val);
        }
        if (listText.isEmpty()) {
            return val;
        }
        return listText.stream().distinct().collect(Collectors.joining(","));
    }

    @Override
    public String queryDictTextByText(String dictCode, String text, String elsAccount) {
        List<String> val = this.dictMapper.queryDictTextByText(dictCode, text, TenantContext.getTenant());
        if (CollectionUtil.isEmpty(val)) {
            val = this.dictMapper.queryDictTextByText(dictCode, text, "100000");
        }
        if (CollectionUtil.isEmpty(val)) {
            return text;
        }
        return val.stream().collect(Collectors.joining(","));
    }
}

