/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.ConvertUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.vo.PermissionVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsSubAccountServiceImpl
extends BaseOpenServiceImpl<ElsSubAccountMapper, ElsSubAccount, ElsSubAccount>
implements ElsSubAccountService {
    private static final Logger log = LoggerFactory.getLogger(ElsSubAccountServiceImpl.class);
    @Resource
    private ElsSubAccountMapper userMapper;
    @Resource
    private PermissionMapper permissionMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RedisUtil redisUtil;
    private static final String ACCCOUNT_LIST_PREFIX = "sys:account:permisson:";

    @Override
    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        List<String> roles = this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272Rules------account\uff1a " + elsAccount + "_" + subAccount + ",Roles size: " + roles.size());
        return new HashSet<String>(roles);
    }

    @Override
    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        HashSet<String> permissionSet = new HashSet<String>();
        List<PermissionVO> permissionList = null;
        String deployWay = SysUtil.getDeployWay();
        permissionList = "cloud".equals(deployWay) ? this.permissionMapper.queryByAccount(elsAccount, subAccount, 0) : this.permissionMapper.queryLocalByAccount(elsAccount, subAccount);
        for (PermissionVO po : permissionList) {
            if (!ConvertUtils.isNotEmpty((Object)po.getPerms())) continue;
            if (po.getPerms().contains(";")) {
                List<String> itemList = Arrays.asList(po.getPerms().split(";"));
                permissionSet.addAll(itemList);
                continue;
            }
            permissionSet.add(po.getPerms());
        }
        return permissionSet;
    }

    @Override
    public ElsSubAccount getByAccount(String elsAccount, String subAccount) {
        return this.userMapper.getUserByAccount(elsAccount + "_" + subAccount);
    }

    @Override
    public List<String> getAccountListByLeader(String elsAccount, String subAccount) {
        ArrayList<String> resultList = (ArrayList<String>)this.redisUtil.get(ACCCOUNT_LIST_PREFIX + elsAccount + subAccount);
        if (resultList != null) {
            return resultList;
        }
        resultList = new ArrayList<String>();
        resultList.add(subAccount);
        this.recursionQuery(resultList, elsAccount, subAccount);
        this.redisUtil.set(ACCCOUNT_LIST_PREFIX + elsAccount + subAccount, resultList);
        return resultList;
    }

    private List<String> recursionQuery(List<String> resultList, String elsAccount, String subAccount) {
        List itemList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).likeRight((Object)"superior_leader", (Object)subAccount));
        if (!itemList.isEmpty()) {
            for (ElsSubAccount item : itemList) {
                if (resultList.contains(item.getSubAccount())) continue;
                resultList.add(item.getSubAccount());
                this.recursionQuery(resultList, elsAccount, item.getSubAccount());
            }
        }
        return resultList;
    }
}

