/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.mapper.PermissionDataMapper;
import com.els.modules.system.service.PermissionDataService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionDataServiceImpl
extends ServiceImpl<PermissionDataMapper, PermissionData>
implements PermissionDataService {
    private static final String PERMISSION_DATA_KEY = "sys:permissionData:";
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<PermissionData> getPermissionDataList(String elsAccount, String subAccount) {
        String redisKey = this.getRedisKey(elsAccount, subAccount);
        List dataList = (List)this.redisUtil.get(redisKey);
        if (dataList == null) {
            dataList = ((PermissionDataMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"sub_account", (Object)subAccount));
            this.redisUtil.set(redisKey, (Object)dataList);
        }
        return dataList;
    }

    @Override
    public List<PermissionData> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        List<PermissionData> dataList = this.getPermissionDataList(elsAccount, subAccount);
        if (dataList != null) {
            dataList = dataList.parallelStream().filter(data -> data.getBusinessType().equals(businessType) || "all".equals(data.getBusinessType())).collect(Collectors.toList());
        }
        return dataList;
    }

    private String getRedisKey(String elsAccount, String subAccount) {
        StringBuilder key = new StringBuilder(PERMISSION_DATA_KEY);
        key.append(elsAccount).append("_").append(subAccount);
        return key.toString();
    }
}

