/*
 * Decompiled with CFR 0.152.
 */
package com.els.rpc.service.impl;

import com.els.common.util.I18nUtil;
import com.els.context.TransactionContext;
import com.els.rpc.service.ManualTransactionManagementService;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;

@Service
public class ManualTransactionManagementSingleServiceImpl
implements ManualTransactionManagementService {
    @Resource
    @Lazy
    private PlatformTransactionManager txManager;

    public void begin() throws Exception {
        this.begin(2);
    }

    public void begin(int timeOut) throws Exception {
        DefaultTransactionDefinition dtd = new DefaultTransactionDefinition();
        dtd.setPropagationBehavior(0);
        dtd.setTimeout(timeOut * 60);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)dtd);
        TransactionContext.setTransaction(status);
    }

    public void rollback() throws Exception {
        try {
            TransactionStatus status = TransactionContext.getTransaction();
            Assert.notNull((Object)status, (String)I18nUtil.translate((String)"i18n_alert_VWvAKSSMQ_3dbf0df4", (String)"\u8bf7\u5148\u5f00\u542f\u4e8b\u52a1\u540e\u56de\u6eda"));
            this.txManager.rollback(status);
        }
        finally {
            TransactionContext.clear();
        }
    }

    public void commit() throws Exception {
        try {
            TransactionStatus status = TransactionContext.getTransaction();
            Assert.notNull((Object)status, (String)I18nUtil.translate((String)"i18n_alert_VWvAKSSDJ_3dc07f0c", (String)"\u8bf7\u5148\u5f00\u542f\u4e8b\u52a1\u540e\u63d0\u4ea4"));
            this.txManager.commit(status);
        }
        finally {
            TransactionContext.clear();
        }
    }
}

