/*
 * Decompiled with CFR 0.152.
 */
package com.els;

import com.els.modules.db.TableEntityScanner;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.annotation.EnableAsync;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@SpringBootApplication(exclude={SecurityAutoConfiguration.class, ManagementWebSecurityAutoConfiguration.class})
@EnableAsync
@ComponentScan(excludeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, value={TableEntityScanner.class})}, basePackages={"com.els"})
public class AiApplication {
    private static final Logger log = LoggerFactory.getLogger(AiApplication.class);
    private static final String projectPath = "/ai";

    public static void main(String[] args) throws UnknownHostException {
        System.setProperty("spring.devtools.restart.enabled", "true");
        ConfigurableApplicationContext application = SpringApplication.run(AiApplication.class, (String[])args);
        ConfigurableEnvironment env = application.getEnvironment();
        System.out.println("2323112321");
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n-----------------------------------------------------------------\n\tApplication-ai is running! Swagger URLs:\n\tLocal: \t\thttp://localhost:" + port + path + "/doc.html\n----------------------------------------------------------");
    }
}

