/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.nlp;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.hankcs.hanlp.seg.Segment;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class NlpProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> segmentWithCustomDict(String queryText, Set<String> protectedTerms) {
        Class<CustomDictionary> clazz = CustomDictionary.class;
        synchronized (CustomDictionary.class) {
            boolean needReload = false;
            for (String term2 : protectedTerms) {
                if (!CustomDictionary.contains((String)term2)) {
                    CustomDictionary.add((String)term2, (String)"nz 1024");
                    needReload = true;
                }
                if (!needReload) continue;
                CustomDictionary.reload();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Segment segment = HanLP.newSegment().enableCustomDictionary(true).enableNameRecognize(true).enableTranslatedNameRecognize(true).enableJapaneseNameRecognize(true).enableOrganizationRecognize(true).enablePlaceRecognize(true);
            List terms = segment.seg(queryText);
            return terms.stream().filter(term -> this.isMeaningfulWord(term.word)).map(term -> term.word).collect(Collectors.toList());
        }
    }

    public List<String> extractKeywords(String text) {
        List terms = HanLP.segment((String)text);
        return terms.stream().filter(term -> this.isMeaningfulWord(term.word)).map(term -> term.word.toLowerCase()).collect(Collectors.toList());
    }

    private boolean isMeaningfulWord(String word) {
        return word.length() > 1 && !word.matches("\\d+");
    }
}

