/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.nlp.service;

import com.els.modules.ai.core.nlp.NlpProcessor;
import com.els.modules.ai.core.nlp.algorithm.ModelInfoMatchingAlgorithm;
import com.els.modules.ai.core.nlp.model.FieldSpec;
import com.els.modules.ai.core.nlp.model.ModelInfo;
import com.els.modules.ai.core.nlp.service.ModelInfoMatchingService;
import com.els.modules.ai.orderCreation.service.AiOrderCreationModelHeadService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HanLpModelInfoMatchingServiceImpl
implements ModelInfoMatchingService {
    @Autowired
    private ModelInfoMatchingAlgorithm matchingAlgorithm;
    @Autowired
    private AiOrderCreationModelHeadService aiOrderCreationModelHeadService;
    @Autowired
    private NlpProcessor nlpProcessor;

    @Override
    public String matchModel(String queryText) {
        List<ModelInfo> allModels = this.aiOrderCreationModelHeadService.getAllModels();
        List<String> questionWords = this.nlpProcessor.segmentWithCustomDict(queryText, allModels.stream().map(ModelInfo::getModelName).collect(Collectors.toSet()));
        List<ModelInfo> nameMatchedModels = this.matchByModelName(questionWords, allModels);
        if (nameMatchedModels.size() == 1) {
            return nameMatchedModels.get(0).getModelId();
        }
        List<ModelInfo> candidateModels = nameMatchedModels.isEmpty() ? allModels : nameMatchedModels;
        Set<String> protectedTerms = candidateModels.stream().map(ModelInfo::getModelName).collect(Collectors.toSet());
        candidateModels.stream().flatMap(x -> x.getFieldSpecs().stream().map(FieldSpec::getFieldName)).forEach(protectedTerms::add);
        questionWords = this.nlpProcessor.segmentWithCustomDict(queryText, protectedTerms);
        return this.matchByFieldSpec(questionWords, candidateModels);
    }

    private List<ModelInfo> matchByModelName(List<String> questionWords, List<ModelInfo> models) {
        questionWords = questionWords.stream().filter(x -> x.length() > 1).toList();
        HashMap<ModelInfo, Integer> modelCounts = new HashMap<ModelInfo, Integer>();
        for (ModelInfo model : models) {
            int count = 0;
            for (String word : questionWords) {
                if (!model.getModelName().contains(word)) continue;
                ++count;
            }
            if (count <= 0) continue;
            modelCounts.put(model, count);
        }
        int maxCount = modelCounts.values().stream().max(Integer::compareTo).orElse(0);
        return modelCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() == maxCount).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private String matchByFieldSpec(List<String> questionWords, List<ModelInfo> models) {
        HashMap<String, Double> modelScores = new HashMap<String, Double>(models.size());
        for (ModelInfo model : models) {
            double score2 = this.matchingAlgorithm.calculateModelMatchingScore(questionWords, model);
            modelScores.put(model.getModelId(), score2);
        }
        if (modelScores.values().stream().allMatch(score -> score == 0.0)) {
            return null;
        }
        return modelScores.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }
}

