/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.flowAgent.core;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.els.modules.ai.dto.AgentLlmRequestDto;
import com.els.modules.ai.dto.LlmResponseDto;
import com.els.modules.ai.flowAgent.core.AgentStrategyFactory;
import com.els.modules.ai.flowAgent.core.vote.VoteStrategy;
import com.els.modules.ai.flowAgent.entity.AiAgentResultConfigItem;
import com.els.modules.ai.flowAgent.enums.AgentStepType;
import com.els.modules.ai.orderCreation.listener.AgentMqUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataResultRunner {
    private static final Logger log = LoggerFactory.getLogger(DataResultRunner.class);

    public static LlmResponseDto vote(AgentLlmRequestDto llmRequest, Map<String, LlmResponseDto> responsePojoMap, List<AiAgentResultConfigItem> aiAgentResultConfigItemList) {
        List<AiAgentResultConfigItem> configItems = aiAgentResultConfigItemList.stream().filter(x -> "1".equals(x.getEnable())).sorted(Comparator.comparing(AiAgentResultConfigItem::getOrderSort)).toList();
        if (configItems.isEmpty()) {
            LlmResponseDto next = responsePojoMap.values().iterator().next();
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.RESULT_VOTE.getType(), "default", 1, JSON.toJSONString((Object)next.getResultText()), "");
            return next;
        }
        if (configItems.size() == 1 && responsePojoMap.size() == 1 && CharSequenceUtil.isEmpty((CharSequence)configItems.get(0).getItemConfig())) {
            LlmResponseDto next = responsePojoMap.values().iterator().next();
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.RESULT_VOTE.getType(), configItems.get(0).getName(), configItems.get(0).getOrderSort(), JSON.toJSONString((Object)next.getResultText()), "");
            return next;
        }
        Map<String, LlmResponseDto> inputMap = new HashMap<String, LlmResponseDto>(responsePojoMap);
        for (AiAgentResultConfigItem item : configItems) {
            if (!CharSequenceUtil.isNotEmpty((CharSequence)item.getItemType())) continue;
            VoteStrategy voteStrategy = AgentStrategyFactory.getVoteStrategy(item.getItemType());
            inputMap = voteStrategy.execute(llmRequest, inputMap, item);
        }
        if (null == inputMap || inputMap.isEmpty()) {
            return responsePojoMap.values().iterator().next();
        }
        return (LlmResponseDto)inputMap.values().iterator().next();
    }
}

