/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.flowAgent.core.clean;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.dto.AgentLlmRequestDto;
import com.els.modules.ai.flowAgent.core.AgentStrategyFactory;
import com.els.modules.ai.flowAgent.core.clean.CleanStrategy;
import com.els.modules.ai.flowAgent.entity.AiAgentDataCleanConfigItem;
import com.els.modules.ai.flowAgent.enums.AgentStepType;
import com.els.modules.ai.orderCreation.listener.AgentMqUtil;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractCleanStrategy
implements CleanStrategy,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        AgentStrategyFactory.register(this.type(), this);
    }

    public abstract JSONObject doExecute(AgentLlmRequestDto var1, AiAgentDataCleanConfigItem var2, JSONObject var3);

    @Override
    public JSONObject execute(AgentLlmRequestDto llmRequest, AiAgentDataCleanConfigItem config, JSONObject input) {
        try {
            JSONObject result = this.doExecute(llmRequest, config, input);
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.CLEAN_DATA.getType(), config.getName(), config.getOrderSort(), null == result ? "" : result.toString(), "");
            return result;
        }
        catch (Exception e) {
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.CLEAN_DATA.getType(), config.getName(), config.getOrderSort(), null == input ? "" : input.toString(), e.getMessage());
            throw e;
        }
    }
}

