/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.flowAgent.core.collect;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.dto.AgentLlmRequestDto;
import com.els.modules.ai.flowAgent.core.AgentStrategyFactory;
import com.els.modules.ai.flowAgent.core.collect.AbstractCollectStrategy;
import com.els.modules.ai.flowAgent.core.collect.result.CollectResultStrategy;
import com.els.modules.ai.flowAgent.entity.AiAgentDataCollectConfigItem;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HttpEngineCollectStrategy
extends AbstractCollectStrategy {
    private static final Logger log = LoggerFactory.getLogger(HttpEngineCollectStrategy.class);

    @Override
    public String type() {
        return "HTTP";
    }

    private static <T> T buildSpelValue(JSONObject inputObj, String config, Class<T> clazz) {
        String[] parts = config.split("\\.");
        JSONObject temObj = inputObj;
        for (int i = 0; i <= parts.length - 2; ++i) {
            if (null == temObj) {
                return null;
            }
            temObj = inputObj.getJSONObject(parts[i]);
        }
        if (null == temObj) {
            return null;
        }
        return (T)temObj.getObject(parts[parts.length - 1], clazz);
    }

    private static <T> Map<String, T> parseParameterMap(String jsonStr, JSONObject questionQuerySchema, Class<T> clazz) {
        HashMap result = new HashMap();
        if (StrUtil.isBlank((CharSequence)jsonStr)) {
            return result;
        }
        if (null == questionQuerySchema) {
            questionQuerySchema = new JSONObject();
        }
        JSONObject paramMap = JSON.parseObject((String)jsonStr);
        JSONObject finalQuestionQuerySchema = questionQuerySchema;
        paramMap.forEach((key, value) -> {
            String spelValue = (String)value;
            if (spelValue.startsWith("#")) {
                String substring = spelValue.substring(1, spelValue.length());
                result.put(key, HttpEngineCollectStrategy.buildSpelValue(finalQuestionQuerySchema, substring, clazz));
            } else {
                result.put(key, spelValue);
            }
        });
        return result;
    }

    @Override
    public String doExecute(AgentLlmRequestDto llmRequest, AiAgentDataCollectConfigItem itemConfig, JSONObject questionQuerySchema) {
        Map<String, String> headers = HttpEngineCollectStrategy.parseParameterMap(itemConfig.getHeaderMapJson(), questionQuerySchema, String.class);
        Map<String, Object> formData = HttpEngineCollectStrategy.parseParameterMap(itemConfig.getFormDataMapJson(), questionQuerySchema, Object.class);
        Method method = "GEP".equals(itemConfig.getRequestMethod()) ? Method.GET : Method.POST;
        HttpResponse execute = ((HttpRequest)HttpUtil.createRequest((Method)method, (String)itemConfig.getUrl()).form(formData).addHeaders(headers)).execute();
        String itemType = itemConfig.getItemType();
        CollectResultStrategy collectResultStrategy = AgentStrategyFactory.getCollectResultStrategy(itemType);
        String responseBody = execute.body();
        questionQuerySchema.put("responseBody", (Object)responseBody);
        return collectResultStrategy.execute(llmRequest, itemConfig, responseBody);
    }
}

