/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.flowAgent.core.vote;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.dto.AgentLlmRequestDto;
import com.els.modules.ai.dto.LlmResponseDto;
import com.els.modules.ai.flowAgent.core.vote.AbstractVoteStrategy;
import com.els.modules.ai.flowAgent.entity.AiAgentResultConfigItem;
import com.els.modules.ai.rpc.service.InvokeAiChatRpcService;
import com.els.modules.ai.service.AiFlowAgentEnhanceRpcService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceBeanEngineVoteStrategy
extends AbstractVoteStrategy {
    private static final Logger log = LoggerFactory.getLogger(ServiceBeanEngineVoteStrategy.class);

    @Override
    public String type() {
        return "SERVICE_BEAN";
    }

    @Override
    public Map<String, LlmResponseDto> doExecute(AgentLlmRequestDto llmRequest, Map<String, LlmResponseDto> responsePojoMap, AiAgentResultConfigItem item) {
        String cleanConfig = item.getItemConfig();
        if (CharSequenceUtil.isNotEmpty((CharSequence)cleanConfig)) {
            try {
                AiFlowAgentEnhanceRpcService bean = ((InvokeAiChatRpcService)SpringContextUtils.getBean(InvokeAiChatRpcService.class)).getAiAgentEnhanceRpcService(cleanConfig.trim());
                return bean.runVoted(llmRequest, responsePojoMap, new String[0]);
            }
            catch (Exception e) {
                throw new ELSBootException(cleanConfig + "\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            }
        }
        return responsePojoMap;
    }
}

