/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.aop;

import com.plumelog.core.TraceId;
import com.plumelog.trace.aspect.AbstractAspect;
import com.qqt.platform.common.dto.LogApiDTO;
import com.qqt.platform.common.event.ApiLogPublisher;
import com.qqt.platform.common.service.SessionService;
import com.qqt.platform.common.utils.WebUtil;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class ApiLogAspect
extends AbstractAspect {
    private static final Logger log = LoggerFactory.getLogger(ApiLogAspect.class);
    @Value(value="${saveLog.api.enabled:false}")
    private boolean enabled;
    @Autowired
    private SessionService sessionService;

    @Pointcut(value="within(@org.springframework.web.bind.annotation.RestController *)")
    public void apiPointcut() {
    }

    @Around(value="apiPointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        String traceId = (String)TraceId.logTraceID.get();
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletResponse response = attributes.getResponse();
            response.addHeader("traceId", traceId);
        }
        catch (Exception e) {
            log.error("set traceId error=>{}", (Object)e.getMessage());
        }
        Object result = this.aroundExecute((JoinPoint)point);
        if (this.enabled) {
            String className = point.getTarget().getClass().getName();
            long time = System.currentTimeMillis() - beginTime;
            MethodSignature signature = (MethodSignature)point.getSignature();
            Method method = signature.getMethod();
            String methodName = method.getName();
            String title = this.getApiDescription(method);
            HttpServletRequest request = WebUtil.getRequest();
            String token = request.getHeader("Authorization");
            Long userId = (Long)this.sessionService.getInfo(token, "userId");
            String login = (String)this.sessionService.getInfo(token, "userCode");
            String elsAccount = (String)this.sessionService.getInfo(token, "elsAccount");
            String companyName = (String)this.sessionService.getInfo(token, "companyName");
            Long companyId = (Long)this.sessionService.getInfo(token, "companyId");
            String siteCode = (String)this.sessionService.getInfo(token, "siteCode");
            LogApiDTO logApiDTO = new LogApiDTO();
            logApiDTO.setTime(time);
            logApiDTO.setLogin(login);
            logApiDTO.setUserId(userId);
            logApiDTO.setSiteCode(siteCode);
            logApiDTO.setElsAccount(elsAccount);
            logApiDTO.setCompanyName(companyName);
            logApiDTO.setCompanyId(companyId);
            logApiDTO.setTitle(title);
            logApiDTO.setMethodClass(className);
            logApiDTO.setMethodName(methodName);
            logApiDTO.setType("1");
            ApiLogPublisher.publishEvent(logApiDTO);
        }
        return result;
    }

    private String getApiDescription(Method method) {
        String title = method.getName();
        if (method.isAnnotationPresent(GetMapping.class)) {
            title = method.getDeclaredAnnotation(GetMapping.class).name();
        } else if (method.isAnnotationPresent(PostMapping.class)) {
            title = method.getDeclaredAnnotation(PostMapping.class).name();
        } else if (method.isAnnotationPresent(PutMapping.class)) {
            title = method.getDeclaredAnnotation(PutMapping.class).name();
        } else if (method.isAnnotationPresent(DeleteMapping.class)) {
            title = method.getDeclaredAnnotation(DeleteMapping.class).name();
        } else if (method.isAnnotationPresent(RequestMapping.class)) {
            title = method.getDeclaredAnnotation(RequestMapping.class).name();
        }
        return title;
    }

    @Around(value="@within(org.springframework.stereotype.Service)")
    public Object serviceAround(JoinPoint joinPoint) throws Throwable {
        return this.aroundExecute(joinPoint);
    }
}

