/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.aop;

import com.qqt.platform.common.dto.LogUsualDTO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.event.UsualLogPublisher;
import com.qqt.platform.common.service.SessionService;
import com.qqt.platform.common.utils.AdminEntityCacheUtils;
import com.qqt.platform.common.utils.WebUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UsualLogger
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(UsualLogger.class);
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${saveLog.usual.level:info}")
    private String level;
    @Autowired
    private SessionService sessionService;
    @Value(value="${saveLog.usual.enabled:true}")
    private String enabled;
    @Autowired
    private AdminEntityCacheUtils adminEntityCacheUtils;

    private void doLog(Level level, String template, Object ... arguments) {
        LogUsualDTO logUsual = this.getLogUsual(level, template, arguments);
        this.publish(logUsual);
    }

    private void publish(LogUsualDTO logUsual) {
        if ("true".equals(this.enabled)) {
            UsualLogPublisher.publishEvent(logUsual);
        }
    }

    private LogUsualDTO getLogUsual(Level level, String template, Object ... arguments) {
        LogUsualDTO logUsual = new LogUsualDTO();
        logUsual.setLogLevel(level.name());
        logUsual.setLogId(Thread.currentThread().getName());
        String message = MessageFormatter.arrayFormat((String)template, (Object[])arguments).getMessage();
        logUsual.setLogData(message);
        HttpServletRequest request = WebUtil.getRequest();
        String token = request.getHeader("Authorization");
        Long userId = (Long)this.sessionService.getInfo(token, "userId");
        Long companyId = (Long)this.sessionService.getInfo(token, "companyId");
        String siteCode = (String)this.sessionService.getInfo(token, "siteCode");
        String login = (String)this.sessionService.getInfo(token, "userCode");
        String elsAccount = (String)this.sessionService.getInfo(token, "elsAccount");
        String companyName = (String)this.sessionService.getInfo(token, "companyName");
        logUsual.setUserId(userId);
        logUsual.setCompanyName(companyName);
        logUsual.setLogin(login);
        logUsual.setElsAccount(elsAccount);
        logUsual.setSiteCode(siteCode);
        logUsual.setCompanyId(companyId);
        UserDetailDO userDO = this.adminEntityCacheUtils.getUserDO(userId);
        if (userDO != null) {
            logUsual.setUserName(userDO.getNameCn());
        }
        return logUsual;
    }

    private LogUsualDTO getLogUsual(Level level, String template, String operateType, String remarks, String userName, String elsAccount, Object ... arguments) {
        LogUsualDTO logUsual = new LogUsualDTO();
        logUsual.setLogLevel(level.name());
        logUsual.setLogId(Thread.currentThread().getName());
        String message = MessageFormatter.arrayFormat((String)template, (Object[])arguments).getMessage();
        logUsual.setLogData(message);
        HttpServletRequest request = WebUtil.getRequest();
        String token = request.getHeader("Authorization");
        Long userId = (Long)this.sessionService.getInfo(token, "userId");
        Long companyId = (Long)this.sessionService.getInfo(token, "companyId");
        String siteCode = (String)this.sessionService.getInfo(token, "siteCode");
        String login = (String)this.sessionService.getInfo(token, "userCode");
        String companyName = (String)this.sessionService.getInfo(token, "companyName");
        if (StringUtils.isEmpty((Object)userName)) {
            userName = (String)this.sessionService.getInfo(token, "userName");
        }
        if (StringUtils.isEmpty((Object)elsAccount)) {
            elsAccount = (String)this.sessionService.getInfo(token, "elsAccount");
        }
        logUsual.setUserId(userId);
        logUsual.setUserName(userName);
        logUsual.setCompanyName(companyName);
        logUsual.setLogin(login);
        logUsual.setElsAccount(elsAccount);
        logUsual.setSiteCode(siteCode);
        logUsual.setCompanyId(companyId);
        logUsual.setOperateType(operateType);
        logUsual.setRemarks(remarks);
        return logUsual;
    }

    public void info(String template, Object arg) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.INFO)) {
            this.doLog(logLevel, template, arg);
        }
    }

    public void info(String template, Object arg1, Object arg2) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.INFO)) {
            this.doLog(logLevel, template, arg1, arg2);
        }
    }

    public void info(String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.INFO)) {
            this.doLog(logLevel, template, arguments);
        }
    }

    public void info(String logId, String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.INFO)) {
            LogUsualDTO logUsual = this.getLogUsual(logLevel, template, arguments);
            if (!StringUtils.isEmpty((Object)logId)) {
                logUsual.setLogId(logId);
            }
            this.publish(logUsual);
        }
    }

    public void info(String logId, String businessId, String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.INFO)) {
            LogUsualDTO logUsual = this.getLogUsual(logLevel, template, arguments);
            if (!StringUtils.isEmpty((Object)logId)) {
                logUsual.setLogId(logId);
            }
            if (!StringUtils.isEmpty((Object)businessId)) {
                logUsual.setBusinessId(businessId);
            }
            this.publish(logUsual);
        }
    }

    public void info(String logId, String businessId, String template, String operateType, String remarks, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.INFO)) {
            LogUsualDTO logUsual = this.getLogUsual(logLevel, template, operateType, remarks, null, null, arguments);
            if (!StringUtils.isEmpty((Object)logId)) {
                logUsual.setLogId(logId);
            }
            if (!StringUtils.isEmpty((Object)businessId)) {
                logUsual.setBusinessId(businessId);
            }
            this.publish(logUsual);
        }
    }

    public void infoByNotToken(String logId, String businessId, String template, String operateType, String remarks, String userName, String elsAccount, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.INFO)) {
            LogUsualDTO logUsual = this.getLogUsual(logLevel, template, operateType, remarks, userName, elsAccount, arguments);
            if (!StringUtils.isEmpty((Object)logId)) {
                logUsual.setLogId(logId);
            }
            if (!StringUtils.isEmpty((Object)businessId)) {
                logUsual.setBusinessId(businessId);
            }
            this.publish(logUsual);
        }
    }

    public void debug(String template, Object arg) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.DEBUG)) {
            this.doLog(logLevel, template, arg);
        }
    }

    public void debug(String template, Object arg1, Object arg2) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.DEBUG)) {
            this.doLog(logLevel, template, arg1, arg2);
        }
    }

    public void debug(String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.DEBUG)) {
            this.doLog(logLevel, template, arguments);
        }
    }

    public void warn(String template, Object arg) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.WARN)) {
            this.doLog(logLevel, template, arg);
        }
    }

    public void warn(String template, Object arg1, Object arg2) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.WARN)) {
            this.doLog(logLevel, template, arg1, arg2);
        }
    }

    public void warn(String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.WARN)) {
            this.doLog(logLevel, template, arguments);
        }
    }

    public void error(String template, Object arg) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.ERROR)) {
            this.doLog(logLevel, template, arg);
        }
    }

    public void error(String template, Object arg1, Object arg2) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.ERROR)) {
            this.doLog(logLevel, template, arg1, arg2);
        }
    }

    public void error(String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.ERROR)) {
            this.doLog(logLevel, template, arguments);
        }
    }

    public void trace(String template, Object arg) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.TRACE)) {
            this.doLog(logLevel, template, arg);
        }
    }

    public void trace(String template, Object arg1, Object arg2) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.TRACE)) {
            this.doLog(logLevel, template, arg1, arg2);
        }
    }

    public void trace(String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.TRACE)) {
            this.doLog(logLevel, template, arguments);
        }
    }

    public void afterPropertiesSet() {
        log.info("{}: UsualLogger init success!", (Object)this.serviceId);
    }
}

