/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.dto.pingan.wrap;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qqt.platform.common.dto.pingan.CustAcctIdBalanceQueryRequest;
import com.qqt.platform.common.dto.pingan.CustAcctIdBalanceQueryResponse;
import com.qqt.platform.common.dto.pingan.PingAnResponseBody;
import com.qqt.platform.common.dto.pingan.wrap.AbstractWrapper;
import com.qqt.platform.common.utils.GsonUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class CustAcctIdBalanceQueryRequestWrapper
extends AbstractWrapper {
    private static final String INTERFACE_ID = "KFEJZB6010";
    private static final String SERVICE_CODE = "/V1.0/CustAcctIdBalanceQuery";
    private CustAcctIdBalanceQueryRequest custAcctIdBalanceQueryRequest;

    public CustAcctIdBalanceQueryRequestWrapper(CustAcctIdBalanceQueryRequest custAcctIdBalanceQueryRequest) {
        this.custAcctIdBalanceQueryRequest = custAcctIdBalanceQueryRequest;
        this.custAcctIdBalanceQueryRequest.setServiceCode(SERVICE_CODE);
        this.custAcctIdBalanceQueryRequest.setTxnCode(INTERFACE_ID);
        super.setPingAnRequestBody(custAcctIdBalanceQueryRequest);
    }

    @Override
    protected AbstractWrapper.BuildResult buildBusinessBody() {
        String queryFlag = this.custAcctIdBalanceQueryRequest.getQueryFlag();
        if (StringUtils.isEmpty((Object)queryFlag)) {
            return new AbstractWrapper.BuildResult(false, "\u53c2\u6570\u975e\u6cd5\uff1aqueryFlag\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("2".equals(queryFlag) && StringUtils.isEmpty((Object)this.custAcctIdBalanceQueryRequest.getSubAcctNo())) {
            return new AbstractWrapper.BuildResult(false, "\u53c2\u6570\u975e\u6cd5\uff1asubAcctNo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)this.custAcctIdBalanceQueryRequest.getPageNum())) {
            return new AbstractWrapper.BuildResult(false, "\u53c2\u6570\u975e\u6cd5\uff1apageNum\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String jsonData = GsonUtils.toJson(this.custAcctIdBalanceQueryRequest);
        return new AbstractWrapper.BuildResult(true, jsonData);
    }

    @Override
    public <T> PingAnResponseBody parse(T data) {
        Map resp = (Map)Map.class.cast(data);
        String txnReturnCode = String.format("%s", resp.get("TxnReturnCode"));
        String txnReturnMsg = String.format("%s", resp.get("TxnReturnMsg"));
        CustAcctIdBalanceQueryResponse result = new CustAcctIdBalanceQueryResponse();
        result.setTxnReturnCode(txnReturnCode);
        result.setTxnReturnMsg(txnReturnMsg);
        if ("000000".equals(txnReturnCode)) {
            result.setCnsmrSeqNo(String.format("%s", resp.get("CnsmrSeqNo")));
            result.setReservedMsg(String.format("%s", resp.get("ReservedMsg")));
            result.setResultNum(String.format("%s", resp.get("ResultNum")));
            result.setStartRecordNo(String.format("%s", resp.get("StartRecordNo")));
            result.setEndFlag(String.format("%s", resp.get("EndFlag")));
            result.setTotalNum(String.format("%s", resp.get("TotalNum")));
            result.setBalanceQueryItemArray(new ArrayList<CustAcctIdBalanceQueryResponse.CustAcctIdBalanceQueryItem>());
            Object acctArray = resp.get("AcctArray");
            if (!Objects.isNull(acctArray)) {
                JSONArray arr = (JSONArray)JSONArray.class.cast(acctArray);
                arr.forEach(item -> {
                    JSONObject obj = (JSONObject)JSONObject.class.cast(item);
                    CustAcctIdBalanceQueryResponse.CustAcctIdBalanceQueryItem balanceQueryItem = new CustAcctIdBalanceQueryResponse.CustAcctIdBalanceQueryItem();
                    balanceQueryItem.setSubAcctNo(obj.getString("SubAcctNo"));
                    balanceQueryItem.setSubAcctProperty(obj.getString("SubAcctProperty"));
                    balanceQueryItem.setTranNetMemberCode(obj.getString("TranNetMemberCode"));
                    balanceQueryItem.setSubAcctName(obj.getString("SubAcctName"));
                    balanceQueryItem.setAcctAvailBal(obj.getString("AcctAvailBal"));
                    balanceQueryItem.setCashAmt(obj.getString("CashAmt"));
                    balanceQueryItem.setMaintenanceDate(obj.getString("MaintenanceDate"));
                    result.getBalanceQueryItemArray().add(balanceQueryItem);
                });
            }
        }
        return result;
    }
}

