/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.qqt.platform.common.excel.ReadExcelListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class EasyExcelUtil {
    private static final HorizontalCellStyleStrategy HORIZONTAL_CELL_STYLE_STRATEGY;

    public static <T> void exportExcel(HttpServletResponse response, List<T> data, String fileName, Class<T> clazz) {
        try {
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ".xlsx");
            ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), clazz).registerWriteHandler((WriteHandler)HORIZONTAL_CELL_STYLE_STRATEGY)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(fileName).doWrite(data);
        }
        catch (Exception e) {
            response.reset();
            throw new RuntimeException("\u4e0b\u8f7d\u5931\u8d25");
        }
    }

    public static <T> List<T> importExcel(InputStream inputStream, Class<T> clazz, String sheetName, ReadExcelListener<T> readExcelListener) throws Exception {
        ExcelReaderBuilder excelReaderBuilder = EasyExcelFactory.read((InputStream)inputStream, clazz, readExcelListener);
        if (StringUtils.isBlank((CharSequence)sheetName)) {
            excelReaderBuilder.sheet().doRead();
        } else {
            excelReaderBuilder.sheet(sheetName).doRead();
        }
        return readExcelListener.getExcelData();
    }

    static {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
        headWriteCellStyle.setWriteFont(headWriteFont);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        HORIZONTAL_CELL_STYLE_STRATEGY = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }
}

