/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadExcelListener<T>
extends AnalysisEventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(ReadExcelListener.class);
    private final List<T> excelData = new ArrayList<T>();
    private Map<Integer, String> headMap = null;

    public List<T> getExcelData() {
        return this.excelData;
    }

    public Map<Integer, String> getHeadMap() {
        return this.headMap;
    }

    public void invoke(T data, AnalysisContext context) {
        this.excelData.add(data);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("[{}]Excel\u8bfb\u53d6\u5b8c\u6210\uff0c\u5171[{}]\u6761\u6570\u636e", (Object)this.getExcelAliasName(), (Object)this.excelData.size());
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        this.headMap = headMap;
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (exception instanceof ExcelDataConvertException) {
            ExcelDataConvertException dataConvertException = (ExcelDataConvertException)exception;
            throw new RuntimeException("\u7b2c" + dataConvertException.getRowIndex() + "\u884c" + dataConvertException.getColumnIndex() + "\u5217,\u6570\u636e\u5f02\u5e38");
        }
        super.onException(exception, context);
    }

    public abstract String getExcelAliasName();
}

