/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.async.aspect;

import com.qqt.platform.common.multitenant.async.executor.AsyncTaskExecutor;
import com.qqt.platform.common.multitenant.async.task.DefaultAsyncTask;
import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import javax.persistence.EntityManager;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
@Order(value=-1)
@Component
public class QQTAsyncAspect {
    private static final Logger log = LoggerFactory.getLogger(QQTAsyncAspect.class);
    @Autowired
    private AsyncTaskExecutor asyncTaskExecutor;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired(required=false)
    private EntityManager entityManager;

    @Pointcut(value="@within(com.qqt.platform.common.multitenant.async.annotation.QQTAsync)")
    public void pointcutOnClass() {
    }

    @Pointcut(value="@annotation(com.qqt.platform.common.multitenant.async.annotation.QQTAsync)")
    public void pointcutOnMethod() {
    }

    @Pointcut(value="pointcutOnClass() || pointcutOnMethod()")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object submitAsyncTask(final ProceedingJoinPoint point) {
        log.info("\u521b\u5efa\u5f02\u6b65\u4efb\u52a1...");
        String dataSourceKey = DynamicDataSourceContextHolder.getDataSourceKey();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        SecurityContext securityContext = SecurityContextHolder.getContext();
        this.asyncTaskExecutor.submitTask(new DefaultAsyncTask(this.transactionManager, dataSourceKey, this.entityManager, requestAttributes, securityContext){

            @Override
            public void doExecute() throws Throwable {
                point.proceed();
            }
        });
        return null;
    }
}

