/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.async.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.qqt.platform.common.multitenant.async.properties.AsyncTaskProperties;
import com.qqt.platform.common.multitenant.async.task.AsyncTaskCallback;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AsyncTaskProperties.class})
public class AsyncTaskExecutor {
    private final Logger log = LoggerFactory.getLogger(AsyncTaskExecutor.class);
    private final AsyncTaskProperties asyncTaskProperties;
    private ExecutorService executorService;
    @Value(value="${spring.application.name}")
    private String appName;

    public AsyncTaskExecutor(AsyncTaskProperties asyncTaskProperties) {
        this.asyncTaskProperties = asyncTaskProperties;
    }

    @PostConstruct
    void initAsyncTaskExecutor() {
        int coreSize = this.asyncTaskProperties.getPool().getCoreSize();
        int maxSize = this.asyncTaskProperties.getPool().getMaxSize();
        int queueCapacity = this.asyncTaskProperties.getPool().getQueueCapacity();
        int keepAlive = this.asyncTaskProperties.getPool().getKeepAlive();
        String threadNamePrefix = this.asyncTaskProperties.getThreadNamePrefix();
        if (StringUtils.isBlank((CharSequence)threadNamePrefix)) {
            threadNamePrefix = this.appName + "-async-task";
        }
        this.log.info("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u7ebf\u7a0b\u6c60, threadName: {}, coreSize: {}, maxSize: {}, queueCapacity: {}, keepAlive: {}", new Object[]{threadNamePrefix, coreSize, maxSize, queueCapacity, keepAlive});
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "-%d").build();
        this.executorService = new ThreadPoolExecutor(coreSize, maxSize, keepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public void submitTask(AsyncTaskCallback task) {
        if (Objects.isNull(task)) {
            this.log.error("\u63d0\u4ea4\u5f02\u6b65\u4efb\u52a1\u5931\u8d25, task is null");
        }
        this.executorService.submit(task);
    }
}

