/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.holder;

import com.qqt.platform.common.multitenant.enums.PlatformDataSourceKeyword;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DynamicDataSourceContextHolder {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceContextHolder.class);
    private static final ThreadLocal<String> contextHolder = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return PlatformDataSourceKeyword.PLATFORM.getKeyword("");
        }
    };
    private static final Set<String> dataSourceKeywords = new HashSet<String>();

    public static void setDataSourceKey(String key) {
        if (StringUtils.isEmpty((Object)key) || !DynamicDataSourceContextHolder.containsDataSourceKey(key)) {
            key = PlatformDataSourceKeyword.PLATFORM.getKeyword("");
        }
        contextHolder.set(key);
    }

    public static String getDataSourceKey() {
        String key = contextHolder.get();
        return key;
    }

    public static void clearDataSourceKey() {
        contextHolder.remove();
    }

    public static void addDataSourceKeywords(List<String> keywords) {
        if (!CollectionUtils.isEmpty(keywords)) {
            dataSourceKeywords.addAll(keywords);
        }
    }

    public static boolean containsDataSourceKey(String key) {
        return dataSourceKeywords.contains(key);
    }

    public static List<String> getDataSourceKeywords() {
        return new ArrayList<String>(dataSourceKeywords);
    }
}

