/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.mybank.api;

import com.qqt.platform.common.mybank.api.AbstractMybankClient;
import com.qqt.platform.common.mybank.api.internal.mapping.DefaultSignChecker;
import com.qqt.platform.common.mybank.api.internal.mapping.DefaultSigner;
import com.qqt.platform.common.mybank.api.internal.mapping.SignChecker;
import com.qqt.platform.common.mybank.api.internal.mapping.Signer;

public class DefaultMybankClient
extends AbstractMybankClient {
    private String privateKey;
    private String mybankPublicKey;
    private Signer signer;
    private SignChecker signChecker;

    public DefaultMybankClient(String serverUrl, String privateKey, String mybankPublicKey) {
        super(serverUrl);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.signChecker = new DefaultSignChecker(mybankPublicKey);
    }

    public DefaultMybankClient(String serverUrl, String charset, String privateKey, String mybankPublicKey) {
        super(serverUrl, charset);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.signChecker = new DefaultSignChecker(mybankPublicKey);
    }

    public DefaultMybankClient(String serverUrl, String charset, String signType, String privateKey, String mybankPublicKey) {
        super(serverUrl, charset, signType);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.signChecker = new DefaultSignChecker(mybankPublicKey);
    }

    public DefaultMybankClient(String serverUrl, String format, String charset, String signType, String privateKey, String mybankPublicKey) {
        super(serverUrl, format, charset, signType);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.signChecker = new DefaultSignChecker(mybankPublicKey);
    }

    public static Builder builder(String serverUrl, String privateKey, String mybankPublicKey) {
        return new Builder(serverUrl, privateKey, mybankPublicKey);
    }

    @Override
    public Signer getSigner() {
        return this.signer;
    }

    @Override
    public SignChecker getSignChecker() {
        return this.signChecker;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        if (this.signer == null) {
            this.signer = new DefaultSigner(privateKey);
        }
    }

    public void setMybankPublicKey(String mybankPublicKey) {
        this.mybankPublicKey = mybankPublicKey;
        if (this.signChecker == null) {
            this.signChecker = new DefaultSignChecker(mybankPublicKey);
        }
    }

    public static class Builder {
        private final DefaultMybankClient client;

        Builder(String serverUrl, String privateKey, String mybankPublicKey) {
            this.client = new DefaultMybankClient(serverUrl, privateKey, mybankPublicKey);
        }

        public DefaultMybankClient build() {
            return this.client;
        }

        public Builder format(String format) {
            this.client.setFormat(format);
            return this;
        }

        public Builder signType(String signType) {
            this.client.setSignType(signType);
            return this;
        }

        public Builder charset(String charset) {
            this.client.setCharset(charset);
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.client.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.client.setReadTimeout(readTimeout);
            return this;
        }
    }
}

