/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.mybank.api.internal.util;

import com.qqt.platform.common.mybank.api.MybankApiException;
import com.qqt.platform.common.mybank.api.MybankApiExceptionEnum;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignatureUtils {
    public static PrivateKey getPrivateKey(String encodePrivateKey, String signType) throws NoSuchAlgorithmException, InvalidKeySpecException, Base64DecodingException {
        byte[] privateKeyBytes = Base64.decode((String)encodePrivateKey);
        KeyFactory kf = KeyFactory.getInstance(signType);
        PrivateKey privateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
        return privateKey;
    }

    public static PublicKey getPublicKey(String encodePublicKey, String signType) throws NoSuchAlgorithmException, InvalidKeySpecException, Base64DecodingException {
        byte[] publicKeyKeyBytes = Base64.decode((String)encodePublicKey);
        KeyFactory kf = KeyFactory.getInstance(signType);
        PublicKey publicKey = kf.generatePublic(new X509EncodedKeySpec(publicKeyKeyBytes));
        return publicKey;
    }

    public static String signXmlElement(PrivateKey privateKey, Document xmlDocument, String elementTagName, String algorithm, int signatureAppendMode) throws MybankApiException, XMLSecurityException {
        XMLSignature xmlSignature = new XMLSignature(xmlDocument, xmlDocument.getDocumentURI(), algorithm);
        NodeList nodeList = xmlDocument.getElementsByTagName(elementTagName);
        if (nodeList == null || nodeList.getLength() - 1 < 0) {
            throw new MybankApiException(MybankApiExceptionEnum.DOCUMENT_ELEMENT_NOT_EXIST);
        }
        Node elementNode = nodeList.item(0);
        if (elementNode == null) {
            throw new MybankApiException(MybankApiExceptionEnum.DOCUMENT_ELEMENT_NOT_EXIST);
        }
        elementNode.appendChild(xmlSignature.getElement());
        if (signatureAppendMode == 1) {
            elementNode.appendChild(xmlSignature.getElement());
        } else if (signatureAppendMode == 2) {
            elementNode.getParentNode().appendChild(xmlSignature.getElement());
        } else {
            throw new MybankApiException(MybankApiExceptionEnum.ILLEGAL_APPEND_MODE);
        }
        Transforms transforms = new Transforms(xmlDocument);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        xmlSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        xmlSignature.sign((Key)privateKey);
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            XMLUtils.outputDOM((Node)xmlDocument, (OutputStream)os);
            String string = os.toString("UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new MybankApiException(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    public static boolean verifyXmlElement(PublicKey publicKey, Document xmlDocument) throws MybankApiException, XMLSecurityException {
        NodeList signatureNodes = xmlDocument.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureNodes == null || signatureNodes.getLength() < 1) {
            throw new MybankApiException(MybankApiExceptionEnum.SIGNATURE_ELEMENT_NOT_EXIST);
        }
        Element signElement = (Element)signatureNodes.item(0);
        if (signElement == null) {
            throw new MybankApiException(MybankApiExceptionEnum.SIGNATURE_ELEMENT_NOT_EXIST);
        }
        XMLSignature signature = new XMLSignature(signElement, "");
        return signature.checkSignatureValue((Key)publicKey);
    }

    static {
        Init.init();
    }
}

