/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.mybank.api.manage;

import com.qqt.platform.common.context.TenantElsAccountContextHolder;
import com.qqt.platform.common.dto.CompanyDO;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.mybank.api.MybankApiException;
import com.qqt.platform.common.mybank.api.MybankApiExceptionEnum;
import com.qqt.platform.common.mybank.api.config.FunctionEnum;
import com.qqt.platform.common.mybank.api.internal.mapping.DefaultSigner;
import com.qqt.platform.common.mybank.api.internal.util.JaxbUtil;
import com.qqt.platform.common.mybank.api.internal.util.MybankSignature;
import com.qqt.platform.common.mybank.api.manage.MyBankConfigInfo;
import com.qqt.platform.common.mybank.api.manage.StrategyFactory;
import com.qqt.platform.common.mybank.api.response.notify.BkcloudfundsNotifyResponseBody;
import com.qqt.platform.common.mybank.api.response.notify.BkmerchantSettleNotifyPayResultResponseBody;
import com.qqt.platform.common.mybank.domain.RequestHead;
import com.qqt.platform.common.mybank.domain.RespInfo;
import com.qqt.platform.common.mybank.domain.Response;
import com.qqt.platform.common.mybank.domain.ResponseBody;
import com.qqt.platform.common.mybank.domain.ResponseDocument;
import com.qqt.platform.common.mybank.domain.ResponseHead;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class CommomRequstHandle {
    private static final Logger log = LoggerFactory.getLogger(CommomRequstHandle.class);
    @Autowired
    private StrategyFactory strategyFactory;
    @Autowired
    private AdminFeignService adminFeignService;

    public MyBankConfigInfo getMybankConfig() {
        String els = TenantElsAccountContextHolder.getElsAccount();
        ResponseEntity<CompanyDO> companyDO = this.adminFeignService.getCompanyByElsAccount(els);
        TenantElsAccountContextHolder.setElsAccount(els);
        log.debug("===========CommomRequstHandle========els=======" + els);
        Map map = (Map)this.adminFeignService.findByCompanyPayDO(((CompanyDO)companyDO.getBody()).getId(), "MYBANK").getBody();
        log.debug("===========CommomRequstHandle========els=======" + els);
        TenantElsAccountContextHolder.setElsAccount(els);
        MyBankConfigInfo myBankConfig = new MyBankConfigInfo(map.get("app_id").toString(), map.get("isv_org_id").toString(), map.get("server_url").toString(), map.get("private_key").toString(), map.get("public_key").toString());
        return myBankConfig;
    }

    public String getXmlContextString(HttpServletRequest httpServletRequest) throws MybankApiException {
        StringWriter writer = new StringWriter();
        BufferedReader reader = null;
        try {
            reader = httpServletRequest.getReader();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
        }
        catch (Exception e) {
            throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION, (Throwable)e);
                }
            }
        }
        return writer.toString();
    }

    public String notifyRequestHandle(String xmlContext) throws MybankApiException {
        String functionName = null;
        String result = null;
        try {
            functionName = this.getNotifyFunction(xmlContext);
            result = this.strategyFactory.getStrategy(FunctionEnum.getStrategyValue(functionName)).notifyHandle(xmlContext, functionName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MybankApiException(e);
        }
        return result;
    }

    public void checkNotifyRequest(String xmlContext) throws MybankApiException {
        boolean signBool = this.checkSign(xmlContext);
        if (!signBool) {
            throw new MybankApiException(MybankApiExceptionEnum.VERIFY_FAIL);
        }
        String notifyAppId = this.getNotifyAppId(xmlContext);
        MyBankConfigInfo myBankConfigInfo = this.getMybankConfig();
        if (!myBankConfigInfo.getAppId().equals(notifyAppId)) {
            throw new MybankApiException(MybankApiExceptionEnum.NOTICE_NOT_MATCH);
        }
    }

    public boolean checkSign(String xmlContext) throws MybankApiException {
        boolean check;
        try {
            MyBankConfigInfo myBankConfigInfo = this.getMybankConfig();
            check = MybankSignature.check(xmlContext, myBankConfigInfo.getMybankPublicKey(), "UTF-8", "RSA");
        }
        catch (MybankApiException e) {
            throw new MybankApiException(e);
        }
        return check;
    }

    public TreeMap<String, String> getNotifyHead(String xmlContext) throws MybankApiException {
        TreeMap<String, String> headMap = new TreeMap<String, String>();
        Document doc = MybankSignature.parseDocumentByString(xmlContext);
        Element root = doc.getDocumentElement();
        Node head = root.getElementsByTagName("head").item(0);
        NodeList childNodes = head.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (childNodes.item(i).getNodeType() != 1) continue;
            headMap.put(childNodes.item(i).getNodeName(), childNodes.item(i).getTextContent());
        }
        return headMap;
    }

    public String getNotifyAppId(String xmlContext) throws MybankApiException {
        TreeMap<String, String> notifyHead = this.getNotifyHead(xmlContext);
        String notifyAppId = null;
        notifyAppId = notifyHead.get("Appid");
        if (null == notifyAppId) {
            notifyAppId = notifyHead.get("AppId");
        }
        return notifyAppId;
    }

    public String getNotifyFunction(String xmlContext) throws MybankApiException {
        TreeMap<String, String> notifyHead = this.getNotifyHead(xmlContext);
        return notifyHead.get("Function");
    }

    public String getSignResult(boolean flag, RequestHead head) throws MybankApiException {
        RespInfo respInfo = new RespInfo();
        if (flag) {
            respInfo.setResultCode("0000");
            respInfo.setResultMsg("\u6210\u529f");
            respInfo.setResultStatus("S");
        } else {
            respInfo.setResultCode("9000");
            respInfo.setResultMsg("\u5931\u8d25");
            respInfo.setResultStatus("F");
        }
        BkcloudfundsNotifyResponseBody responseBody = new BkcloudfundsNotifyResponseBody();
        responseBody.setRespInfo(respInfo);
        return this.responseAndSign(head, responseBody);
    }

    public String responseAndSign(RequestHead head, ResponseBody responseBody) throws MybankApiException {
        ResponseHead responseHead = null != head.getAppid() ? ResponseHead.builder(head.getVersion(), null, head.getAppid(), head.getFunction(), head.getReqMsgId()).inputCharset("UTF-8").respTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"))).respTimeZone("UTC+8").reserve("").signType("RSA").build() : ResponseHead.builder(head.getVersion(), head.getAppId(), null, head.getFunction(), head.getReqMsgId()).inputCharset("UTF-8").respTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"))).respTimeZone("UTC+8").reserve("").signType("RSA").build();
        ResponseDocument responseDocument = new ResponseDocument(new Response(responseHead, responseBody));
        MyBankConfigInfo myBankConfigInfo = this.getMybankConfig();
        DefaultSigner signer = new DefaultSigner(myBankConfigInfo.getPrivateKey());
        String result = null;
        try {
            String xml = JaxbUtil.convertToXml(responseDocument, "UTF-8");
            result = signer.notifyResponseSign(xml, "UTF-8", "RSA");
        }
        catch (MybankApiException e) {
            throw new MybankApiException(e);
        }
        return result;
    }

    public String getNotifyPayResult(boolean flag, RequestHead head) throws MybankApiException {
        MyBankConfigInfo myBankConfigInfo = this.getMybankConfig();
        BkmerchantSettleNotifyPayResultResponseBody notifyPayResultResponseBody = new BkmerchantSettleNotifyPayResultResponseBody();
        notifyPayResultResponseBody.setIsvOrgId(myBankConfigInfo.getIsvOrgId());
        if (flag) {
            notifyPayResultResponseBody.setResponseCode("OK");
        } else {
            notifyPayResultResponseBody.setResponseCode("FAIL");
        }
        return this.responseAndSign(head, notifyPayResultResponseBody);
    }

    public static void main(String[] args) {
        System.out.println(FunctionEnum.getStrategyValue("ant.mybank.merchantprod.merchant.arrangement.info.notify"));
    }
}

