/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.notice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qqt.platform.common.context.TenantElsAccountContextHolder;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.SmsDO;
import com.qqt.platform.common.dto.UserDTO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.dto.UserGroupDO;
import com.qqt.platform.common.dto.message.MessageBodyDTO;
import com.qqt.platform.common.dto.message.UserTargetDTO;
import com.qqt.platform.common.enumeration.SourceTypeEnum;
import com.qqt.platform.common.facade.MessageSendFacade;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.multitenant.async.executor.AsyncTaskExecutor;
import com.qqt.platform.common.multitenant.async.task.DefaultAsyncTask;
import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import com.qqt.platform.common.notice.dto.BaseNoticeDTO;
import com.qqt.platform.common.notice.dto.DeductConfigContractExpireNoticeDTO;
import com.qqt.platform.common.notice.dto.MaterialArchivesOfflineNoticeDTO;
import com.qqt.platform.common.notice.dto.MaterialArchivesOnlineNoticeDTO;
import com.qqt.platform.common.notice.dto.MaterialMappingOfflineNoticeDTO;
import com.qqt.platform.common.notice.dto.MaterialMappingOnlineNoticeDTO;
import com.qqt.platform.common.notice.dto.ModifyNoticeDesignRejectNoticeDTO;
import com.qqt.platform.common.notice.dto.OrderNoticeConfirmNoticeDTO;
import com.qqt.platform.common.notice.dto.OrderPaySuccessNoticeDTO;
import com.qqt.platform.common.notice.dto.OrderUnPayOvertimeNoticeDTO;
import com.qqt.platform.common.notice.dto.PostSaleReturnRefundCreateNoticeDTO;
import com.qqt.platform.common.notice.dto.StockManageWarningNoticeDTO;
import com.qqt.platform.common.notice.dto.StockPlanNoticeDTO;
import com.qqt.platform.common.notice.dto.SupplierDeliveredNoticeDTO;
import com.qqt.platform.common.notice.dto.WaitOrderDecorationCreateNoticeDTO;
import com.qqt.platform.common.notice.enums.MessageMainCodeEnum;
import com.qqt.platform.common.notice.service.YhtMessageNoticeService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class YhtMessageNoticeServiceImpl
implements YhtMessageNoticeService {
    private final Logger log = LoggerFactory.getLogger(YhtMessageNoticeServiceImpl.class);
    @Autowired
    private MessageSendFacade messageSendFacade;
    @Autowired
    private AsyncTaskExecutor asyncTaskExecutor;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired(required=false)
    private EntityManager entityManager;
    @Autowired
    private AdminFeignService adminFeignService;

    @Override
    public List<Long> queryUserGroupIdsByOrgLabel(String orgLabel, Long companyId) {
        ResponseEntity<List<UserGroupDO>> responseEntity = this.adminFeignService.queryUserGroupsByOrgLabel(orgLabel, companyId);
        if (Objects.nonNull(responseEntity) && CollectionUtils.isNotEmpty((Collection)((Collection)responseEntity.getBody()))) {
            List<Long> receiverUserGroupIds = ((List)responseEntity.getBody()).stream().map(UserGroupDO::getId).collect(Collectors.toList());
            return receiverUserGroupIds;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Long> queryRootUserIdsByCompanyId(Long companyId) {
        ResultDTO<List<UserDTO>> resultDTO = this.adminFeignService.getUserByCompanyIdAndUserType(companyId, "Root");
        if (Objects.nonNull(resultDTO) && CollectionUtils.isNotEmpty((Collection)resultDTO.getData())) {
            return resultDTO.getData().stream().map(UserDTO::getId).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void materialArchivesOfflineNotice(MaterialArchivesOfflineNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("materialName", (Object)noticeDTO.getMaterialName());
        mainParam.put("skuCode", (Object)noticeDTO.getSkuCode());
        mainParam.put("offlineReason", (Object)noticeDTO.getOfflineReason());
        mainParam.put("userName", (Object)noticeDTO.getUserName());
        mainParam.put("userPhone", (Object)noticeDTO.getUserPhone());
        mainParam.put("offlineDate", (Object)noticeDTO.getOfflineDate());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_MATERIALARCHIVES_OFFLINE, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_MATERIALARCHIVES_OFFLINE, mainParam);
        }
    }

    @Override
    public void materialArchivesOnlineNotice(MaterialArchivesOnlineNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("materialName", (Object)noticeDTO.getMaterialName());
        mainParam.put("skuCode", (Object)noticeDTO.getSkuCode());
        mainParam.put("onlineReason", (Object)noticeDTO.getOnlineReason());
        mainParam.put("userName", (Object)noticeDTO.getUserName());
        mainParam.put("userPhone", (Object)noticeDTO.getUserPhone());
        mainParam.put("onlineDate", (Object)noticeDTO.getOnlineDate());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_MATERIALARCHIVES_ONLINE, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_MATERIALARCHIVES_ONLINE, mainParam);
        }
    }

    @Override
    public void materialMappingOfflineNotice(MaterialMappingOfflineNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("materialName", (Object)noticeDTO.getMaterialName());
        mainParam.put("skuCode", (Object)noticeDTO.getSkuCode());
        mainParam.put("supplierName", (Object)noticeDTO.getSupplierName());
        mainParam.put("supplierCode", (Object)noticeDTO.getSupplierCode());
        mainParam.put("offlineReason", (Object)noticeDTO.getOfflineReason());
        mainParam.put("userName", (Object)noticeDTO.getUserName());
        mainParam.put("userPhone", (Object)noticeDTO.getUserPhone());
        mainParam.put("offlineDate", (Object)noticeDTO.getOfflineDate());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_MATERIALMAPPING_OFFLINE, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_MATERIALMAPPING_OFFLINE, mainParam);
        }
    }

    @Override
    public void materialMappingOnlineNotice(MaterialMappingOnlineNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("materialName", (Object)noticeDTO.getMaterialName());
        mainParam.put("skuCode", (Object)noticeDTO.getSkuCode());
        mainParam.put("supplierName", (Object)noticeDTO.getSupplierName());
        mainParam.put("supplierCode", (Object)noticeDTO.getSupplierCode());
        mainParam.put("onlineReason", (Object)noticeDTO.getOnlineReason());
        mainParam.put("userName", (Object)noticeDTO.getUserName());
        mainParam.put("userPhone", (Object)noticeDTO.getUserPhone());
        mainParam.put("onlineDate", (Object)noticeDTO.getOnlineDate());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_MATERIALMAPPING_ONLINE, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_MATERIALMAPPING_ONLINE, mainParam);
        }
    }

    @Override
    public void stockManageWarningNotice(StockManageWarningNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("materialName", (Object)noticeDTO.getMaterialName());
        mainParam.put("skuCode", (Object)noticeDTO.getSkuCode());
        mainParam.put("stockQuantity", (Object)noticeDTO.getStockQuantity());
        mainParam.put("stockThreshold", (Object)noticeDTO.getStockThreshold());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_STOCKMANAGE_WARNING, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_STOCKMANAGE_WARNING, mainParam);
        }
    }

    @Override
    public void postSaleReturnRefundCreateNotice(PostSaleReturnRefundCreateNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("storeName", (Object)noticeDTO.getStoreName());
        mainParam.put("billType", (Object)noticeDTO.getBillType());
        mainParam.put("billCode", (Object)noticeDTO.getBillCode());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_POSTSALE_RETURNREFUNDCREATE, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_POSTSALE_RETURNREFUNDCREATE, mainParam);
        }
    }

    @Override
    public void orderPaySuccessNotice(OrderPaySuccessNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("storeName", (Object)noticeDTO.getStoreName());
        mainParam.put("orderCode", (Object)noticeDTO.getOrderCode());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_ORDER_PAYSUCCESS, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_ORDER_PAYSUCCESS, mainParam);
        }
    }

    @Override
    public void stockPlanSupplierConfirmNotice(StockPlanNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("planCode", (Object)noticeDTO.getPlanCode());
        mainParam.put("supplierName", (Object)noticeDTO.getSupplierName());
        mainParam.put("supplierCode", (Object)noticeDTO.getSupplierCode());
        mainParam.put("confirmDate", (Object)noticeDTO.getConfirmDate());
        mainParam.put("productName", (Object)noticeDTO.getProductName());
        mainParam.put("productCode", (Object)noticeDTO.getProductCode());
        mainParam.put("planQuantity", (Object)noticeDTO.getPlanQuantity());
        mainParam.put("stockDays", (Object)noticeDTO.getStockDays());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_STOCKPLAN_SUPPLIERCONFIRM, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_STOCKPLAN_SUPPLIERCONFIRM, mainParam);
        }
    }

    @Override
    public void stockPlanSubmitPlanNotice(StockPlanNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("planCode", (Object)noticeDTO.getPlanCode());
        mainParam.put("supplierName", (Object)noticeDTO.getSupplierName());
        mainParam.put("supplierCode", (Object)noticeDTO.getSupplierCode());
        mainParam.put("confirmDate", (Object)noticeDTO.getConfirmDate());
        mainParam.put("productName", (Object)noticeDTO.getProductName());
        mainParam.put("productCode", (Object)noticeDTO.getProductCode());
        mainParam.put("planQuantity", (Object)noticeDTO.getPlanQuantity());
        mainParam.put("stockDays", (Object)noticeDTO.getStockDays());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_STOCKPLAN_SUBMITPLAN, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_STOCKPLAN_SUBMITPLAN, mainParam);
        }
    }

    @Override
    public void waitOrderDecorationCreateNotice(WaitOrderDecorationCreateNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("storeName", (Object)noticeDTO.getStoreName());
        mainParam.put("code", (Object)noticeDTO.getCode());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_WAITORDER_DECORATIONCREATE, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_WAITORDER_DECORATIONCREATE, mainParam);
        }
    }

    @Override
    public void modifyNoticeDesignRejectNotice(ModifyNoticeDesignRejectNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("orderCode", (Object)noticeDTO.getOrderCode());
        mainParam.put("storeName", (Object)noticeDTO.getStoreName());
        mainParam.put("contractCode", (Object)noticeDTO.getContractCode());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_MODIFYNOTICE_DESIGNREJECT, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_MODIFYNOTICE_DESIGNREJECT, mainParam);
        }
    }

    @Override
    public void orderNoticeDesignConfirmNotice(OrderNoticeConfirmNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("demandCode", (Object)noticeDTO.getDemandCode());
        mainParam.put("storeName", (Object)noticeDTO.getStoreName());
        mainParam.put("contractCode", (Object)noticeDTO.getContractCode());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_ORDERNOTICE_DESIGNCONFIRM, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_ORDERNOTICE_DESIGNCONFIRM, mainParam);
        }
    }

    @Override
    public void orderNoticeSupervisorConfirmNotice(OrderNoticeConfirmNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("demandCode", (Object)noticeDTO.getDemandCode());
        mainParam.put("storeName", (Object)noticeDTO.getStoreName());
        mainParam.put("contractCode", (Object)noticeDTO.getContractCode());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_ORDERNOTICE_SUPERVISORCONFIRM, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_ORDERNOTICE_SUPERVISORCONFIRM, mainParam);
        }
        if (noticeDTO.isSendSms()) {
            this.sendSmsNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SMS_YHT_ORDERNOTICE_SUPERVISORCONFIRM, mainParam);
        }
    }

    @Override
    public void constructionOrderFranchiseeRejectNotice(OrderNoticeConfirmNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("demandCode", (Object)noticeDTO.getDemandCode());
        mainParam.put("storeName", (Object)noticeDTO.getStoreName());
        mainParam.put("contractCode", (Object)noticeDTO.getContractCode());
        mainParam.put("customerRejectCause", (Object)noticeDTO.getCustomerRejectCause());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_CONSTRUCTIONORDER_FRANCHISEEREJECT, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_CONSTRUCTIONORDER_FRANCHISEEREJECT, mainParam);
        }
    }

    @Override
    public void deliveredNoticeSupplierDeliveredNotice(SupplierDeliveredNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("storeName", (Object)noticeDTO.getStoreName());
        mainParam.put("orderCode", (Object)noticeDTO.getOrderCode());
        mainParam.put("deliverCode", (Object)noticeDTO.getDeliverCode());
        mainParam.put("supplierCompanyName", (Object)noticeDTO.getSupplierCompanyName());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_DELIVEREDNOTICE_SUPPLIERDELIVERED, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_DELIVEREDNOTICE_SUPPLIERDELIVERED, mainParam);
        }
    }

    @Override
    public void deductConfigContractExpireNotice(DeductConfigContractExpireNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("supplierName", (Object)noticeDTO.getSupplierName());
        mainParam.put("endDate", (Object)noticeDTO.getEndDate());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_DEDUCTCONFIG_CONTRACTEXPIRE, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_DEDUCTCONFIG_CONTRACTEXPIRE, mainParam);
        }
    }

    @Override
    public void orderUnPayOvertimeNotice(OrderUnPayOvertimeNoticeDTO noticeDTO) {
        JSONObject mainParam = new JSONObject();
        mainParam.put("franchiseeName", (Object)noticeDTO.getFranchiseeName());
        mainParam.put("orderCode", (Object)noticeDTO.getOrderCode());
        mainParam.put("orderDate", (Object)noticeDTO.getOrderDate());
        if (noticeDTO.isSendSIL()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_SIL_YHT_ORDERUNPAY_OVERTIME, mainParam);
        }
        if (noticeDTO.isSendMail()) {
            this.sendMessageNotice(noticeDTO, MessageMainCodeEnum.MAIN_CODE_MAIL_YHT_ORDERUNPAY_OVERTIME, mainParam);
        }
    }

    private void sendMessageNotice(final BaseNoticeDTO noticeDTO, final MessageMainCodeEnum messageMainCodeEnum, final JSONObject mainParam) {
        String dataSourceKey = DynamicDataSourceContextHolder.getDataSourceKey();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        SecurityContext securityContext = SecurityContextHolder.getContext();
        final String els = TenantElsAccountContextHolder.getElsAccount();
        this.asyncTaskExecutor.submitTask(new DefaultAsyncTask(this.transactionManager, dataSourceKey, this.entityManager, requestAttributes, securityContext){

            @Override
            public void doExecute() {
                try {
                    TenantElsAccountContextHolder.setElsAccount(els);
                    YhtMessageNoticeServiceImpl.this.log.info("\u53d1\u9001{}, \u6a21\u677fcode: {}, noticeDTO: {}, mainParam: {}", new Object[]{messageMainCodeEnum.getDesc(), messageMainCodeEnum.getCode(), JSON.toJSONString((Object)noticeDTO), mainParam.toJSONString()});
                    MessageBodyDTO bodyDTO = new MessageBodyDTO();
                    bodyDTO.setSourceId(Long.valueOf(noticeDTO.getSenderId()));
                    bodyDTO.setSourceName(noticeDTO.getSenderName());
                    bodyDTO.setSourceType(SourceTypeEnum.USER.name());
                    bodyDTO.setMainCode(messageMainCodeEnum.getCode());
                    HashSet<UserTargetDTO> userTargets = new HashSet<UserTargetDTO>();
                    if (CollectionUtils.isNotEmpty(noticeDTO.getReceiverUserGroupIds())) {
                        noticeDTO.getReceiverUserGroupIds().stream().distinct().forEach(userGroupId -> {
                            UserTargetDTO userTarget = new UserTargetDTO();
                            userTarget.setTargetType(SourceTypeEnum.USERGROUP.name());
                            userTarget.setTargetId((Long)userGroupId);
                            userTargets.add(userTarget);
                        });
                    }
                    if (CollectionUtils.isNotEmpty(noticeDTO.getReceiverUserIds())) {
                        noticeDTO.getReceiverUserIds().stream().distinct().forEach(userId -> {
                            UserTargetDTO userTarget = new UserTargetDTO();
                            userTarget.setTargetType(SourceTypeEnum.USER.name());
                            userTarget.setTargetId((Long)userId);
                            userTargets.add(userTarget);
                        });
                    }
                    bodyDTO.setUserTargets(userTargets);
                    bodyDTO.setMainParams(mainParam.toJSONString());
                    if (CollectionUtils.isNotEmpty(userTargets) && Objects.nonNull(bodyDTO.getSourceId())) {
                        ResultDTO resultDTO = YhtMessageNoticeServiceImpl.this.messageSendFacade.sendMsg(bodyDTO);
                        YhtMessageNoticeServiceImpl.this.log.info("\u53d1\u9001{}\u6210\u529f, \u6a21\u677fcode: {}, noticeDTO: {}, mainParam: {}, resultDTO: {}", new Object[]{messageMainCodeEnum.getDesc(), messageMainCodeEnum.getCode(), JSON.toJSONString((Object)noticeDTO), mainParam.toJSONString(), resultDTO.getData()});
                    } else {
                        YhtMessageNoticeServiceImpl.this.log.error("\u53d1\u9001{}\u5931\u8d25\uff0c\u53d1\u9001\u4eba\u6216\u63a5\u6536\u4eba\u4e3a\u7a7a, \u6a21\u677fcode: {}, noticeDTO: {}, mainParam: {}", new Object[]{messageMainCodeEnum.getDesc(), messageMainCodeEnum.getCode(), JSON.toJSONString((Object)noticeDTO), mainParam.toJSONString()});
                    }
                }
                catch (Exception e) {
                    YhtMessageNoticeServiceImpl.this.log.error("\u53d1\u9001" + messageMainCodeEnum.getDesc() + "\u5f02\u5e38, \u6a21\u677fcode: " + messageMainCodeEnum.getCode() + ", \u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString((Object)noticeDTO) + ", mainParam: " + mainParam.toJSONString(), (Throwable)e);
                }
            }
        });
    }

    private void sendSmsNotice(final BaseNoticeDTO noticeDTO, final MessageMainCodeEnum messageMainCodeEnum, final JSONObject mainParam) {
        String dataSourceKey = DynamicDataSourceContextHolder.getDataSourceKey();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        SecurityContext securityContext = SecurityContextHolder.getContext();
        this.asyncTaskExecutor.submitTask(new DefaultAsyncTask(this.transactionManager, dataSourceKey, this.entityManager, requestAttributes, securityContext){

            @Override
            public void doExecute() {
                try {
                    YhtMessageNoticeServiceImpl.this.log.info("\u77ed\u4fe1\u53d1\u9001{}, \u6a21\u677fcode: {}, noticeDTO: {}, mainParam: {}", new Object[]{messageMainCodeEnum.getDesc(), messageMainCodeEnum.getCode(), JSON.toJSONString((Object)noticeDTO), mainParam.toJSONString()});
                    ResultDTO<List<UserDetailDO>> resultDTO = YhtMessageNoticeServiceImpl.this.adminFeignService.getUserByIds(noticeDTO.getReceiverUserIds());
                    if (Objects.nonNull(resultDTO) && CollectionUtils.isNotEmpty((Collection)resultDTO.getData())) {
                        List phoneNumbers = resultDTO.getData().stream().map(UserDetailDO::getPhone).collect(Collectors.toList());
                        phoneNumbers.stream().forEach(phoneNumber -> {
                            SmsDO smsDO = new SmsDO();
                            smsDO.setBusinessCode(messageMainCodeEnum.getCode());
                            smsDO.setPhone((String)phoneNumber);
                            smsDO.setContent(mainParam.toJSONString());
                            YhtMessageNoticeServiceImpl.this.adminFeignService.sendSms(smsDO);
                        });
                    }
                }
                catch (Exception e) {
                    YhtMessageNoticeServiceImpl.this.log.error("\u77ed\u4fe1\u53d1\u9001" + messageMainCodeEnum.getDesc() + "\u5f02\u5e38, \u6a21\u677fcode: " + messageMainCodeEnum.getCode() + ", \u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString((Object)noticeDTO) + ", mainParam: " + mainParam.toJSONString(), (Throwable)e);
                }
            }
        });
    }
}

