/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.service;

import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.SerialNumGeneratorDO;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.multitenant.async.executor.AsyncTaskExecutor;
import com.qqt.platform.common.multitenant.async.task.DefaultAsyncTask;
import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import com.qqt.platform.common.service.FormNoSerialUtil;
import com.qqt.platform.common.service.FormNoTypeEnum;
import com.qqt.platform.common.utils.SnowflakeIdWorker;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class SerialNumberGeneratorService {
    private final Logger logger = LoggerFactory.getLogger(SerialNumberGeneratorService.class);
    private static final String PREFIX_DEFAULT = "default";
    public static final String LOCK_GENERATE_SERIAL_NUMBER = "LOCK_GENERATE_SERIAL_NUMBER";
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private AsyncTaskExecutor asyncTaskExecutor;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired(required=false)
    private EntityManager entityManager;
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired(required=false)
    private RedissonClient redissonClient;

    public String generateSerialNumber(String prefixString) {
        try {
            return prefixString + this.snowflakeIdWorker.nextId();
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
            return "";
        }
    }

    public String generateSerialNumber(FormNoTypeEnum formNoTypeEnum) {
        return this.generateSerialNumber(formNoTypeEnum.getPrefix(), formNoTypeEnum.getDatePattern(), formNoTypeEnum.getSerialLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateSerialNumber(String prefix, String datePattern, Integer serialLength) {
        String lockKey = this.getLockKeyByGenerateSerialNumber(prefix);
        RLock lock = this.redissonClient.getLock(lockKey);
        try {
            String serialWithPrefix;
            lock.lock();
            StringBuffer sb = new StringBuffer();
            sb.append(prefix);
            String format = "";
            if (StringUtils.isNotEmpty((CharSequence)datePattern)) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
                format = formatter.format(LocalDateTime.now());
                sb.append(format);
            }
            String formNoPrefix = sb.toString();
            Long incrementalSerial = 1L;
            try {
                byte[] val = this.redisTemplate.getConnectionFactory().getConnection().get(this.redisTemplate.getKeySerializer().serialize((Object)prefix));
                boolean flag = false;
                if (val == null) {
                    ResultDTO<SerialNumGeneratorDO> resultDTO = null;
                    try {
                        if ("".equals(prefix)) {
                            prefix = PREFIX_DEFAULT;
                        }
                        resultDTO = this.adminFeignService.getUniqueSerialNumberGenerator(prefix, format, serialLength);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.logger.info("\u751f\u6210\u5e8f\u5217\u53f7\u53c2\u6570-\u524d\u7f00:{}-\u65f6\u95f4\u683c\u5f0f:{}-\u957f\u5ea6:{},\u4ecedb\u4e2d\u83b7\u53d6\u7684\u5e8f\u5217\u53f7\u6570\u636e:{}", new Object[]{prefix, format, serialLength, resultDTO != null ? resultDTO.getData() : null});
                    if (resultDTO != null && resultDTO.isSuccess() && resultDTO.getData() != null && resultDTO.getData().getCurAutoNum() != null) {
                        long timeout = this.getTimeout(datePattern);
                        SerialNumGeneratorDO data = resultDTO.getData();
                        Long curAutoNum = data.getCurAutoNum();
                        incrementalSerial = curAutoNum + 1L;
                        this.logger.info("\u751f\u6210\u5e8f\u5217\u53f7\u53c2\u6570-\u524d\u7f00:{}-\u65f6\u95f4\u683c\u5f0f:{}-\u957f\u5ea6:{},\u65b0\u7684\u5e8f\u5217\u53f7:{}", new Object[]{prefix, format, serialLength, incrementalSerial});
                        this.redisTemplate.getConnectionFactory().getConnection().setEx(this.redisTemplate.getKeySerializer().serialize((Object)prefix), TimeUnit.MILLISECONDS.toSeconds(timeout), this.redisTemplate.getKeySerializer().serialize((Object)incrementalSerial.toString()));
                        this.syncDB(prefix, format, serialLength, incrementalSerial, data.getId());
                    } else {
                        flag = true;
                    }
                }
                if ((val != null || flag) && (incrementalSerial = this.redisTemplate.getConnectionFactory().getConnection().incr(this.redisTemplate.getKeySerializer().serialize((Object)prefix))) != null) {
                    if (incrementalSerial == 1L) {
                        long timeout = this.getTimeout(datePattern);
                        this.redisTemplate.expire((Object)prefix, timeout, TimeUnit.MILLISECONDS);
                    }
                    this.syncDB(prefix, format, serialLength, incrementalSerial, null);
                }
            }
            catch (Exception e) {
                this.logger.error("generateSequenceNumber error\uff1a", (Throwable)e);
            }
            String string = serialWithPrefix = FormNoSerialUtil.completionSerial(formNoPrefix, incrementalSerial, serialLength);
            return string;
        }
        catch (Exception ex) {
            this.logger.error("generateSequenceNumber error\uff1a", (Throwable)ex);
        }
        finally {
            lock.unlock();
        }
        return "";
    }

    private String getLockKeyByGenerateSerialNumber(String prefix) {
        StringBuffer lockKey = new StringBuffer();
        lockKey.append(LOCK_GENERATE_SERIAL_NUMBER);
        lockKey.append(":");
        lockKey.append(prefix);
        return lockKey.toString();
    }

    private long getTimeout(String datePattern) {
        if (StringUtils.isEmpty((CharSequence)datePattern)) {
            return -1L;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDate tomorrow = now.toLocalDate().plusDays(1L);
        LocalDateTime last = tomorrow.atTime(0, 0, 0, 0);
        long end = last.toInstant(ZoneOffset.UTC).toEpochMilli();
        long start = now.toInstant(ZoneOffset.UTC).toEpochMilli();
        long timeout = end - start;
        return timeout;
    }

    private void syncDB(final String prefix, final String datePattern, final Integer serialLength, Long serialNo, Long id) {
        final SerialNumGeneratorDO data = new SerialNumGeneratorDO();
        data.setId(id);
        data.setDatePattern(datePattern);
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            data.setPrefix(PREFIX_DEFAULT);
        } else {
            data.setPrefix(prefix);
        }
        data.setSerialLength(serialLength);
        data.setCurAutoNum(serialNo);
        final RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        final SecurityContext context = SecurityContextHolder.getContext();
        String dataSourceKey = DynamicDataSourceContextHolder.getDataSourceKey();
        this.asyncTaskExecutor.submitTask(new DefaultAsyncTask(this.transactionManager, dataSourceKey, this.entityManager, requestAttributes, context){

            @Override
            public void doExecute() {
                try {
                    SecurityContextHolder.setContext((SecurityContext)context);
                    RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                    ResultDTO dto = SerialNumberGeneratorService.this.adminFeignService.syncSerialNumberGenerator(data);
                    SerialNumberGeneratorService.this.logger.info("\u751f\u6210\u5e8f\u5217\u53f7\u53c2\u6570-\u524d\u7f00:{}-\u65f6\u95f4\u683c\u5f0f:{}-\u957f\u5ea6:{},\u5f02\u6b65\u540c\u6b65db\u7684\u5e8f\u5217\u53f7\uff0c\u662f\u5426\u6210\u529f:{}", new Object[]{prefix, datePattern, serialLength, dto.isSuccess()});
                }
                catch (Exception e) {
                    SerialNumberGeneratorService.this.logger.info("\u751f\u6210\u5e8f\u5217\u53f7\u53c2\u6570-\u524d\u7f00:{}-\u65f6\u95f4\u683c\u5f0f:{}-\u957f\u5ea6:{},\u5f02\u6b65\u540c\u6b65db\u7684\u5e8f\u5217\u53f7\u5931\u8d25:{}", new Object[]{prefix, datePattern, serialLength, e.getMessage()});
                }
            }
        });
    }
}

