/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.qqt.platform.common.config.KafkaMessage;
import com.qqt.platform.common.dto.DataOperateLogDTO;
import com.qqt.platform.common.security.SecurityUtils;
import com.qqt.platform.common.service.SessionService;
import com.qqt.platform.common.utils.KafkaProduceUtil;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DataOperateLogUtil
implements InitializingBean {
    private Logger logger = LoggerFactory.getLogger(KafkaProduceUtil.class);
    @Autowired
    private SessionService sessionService;
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Value(value="${spring.profiles.active}")
    private String env;

    public void send(String operateType, Serializable id, Class clazz, Object entity, Object target) {
        try {
            DataOperateLogDTO logDTO = new DataOperateLogDTO();
            logDTO.setEntityId(id);
            logDTO.setEntityName(clazz.getSimpleName());
            logDTO.setOperateType(operateType);
            if (null != entity) {
                logDTO.setEntity(entity);
            }
            if (null != target) {
                logDTO.setTarget(target);
            }
            if (ObjectUtil.isNotEmpty((Object)this.sessionService)) {
                Long userId = this.sessionService.getCurrentUserId();
                String login = this.sessionService.getCurrentUserName();
                Optional<String> loginOptional = SecurityUtils.getCurrentUserLogin();
                if (loginOptional.isPresent()) {
                    login = loginOptional.get();
                }
                String elsAccount = this.sessionService.getElsAccount();
                String companyName = this.sessionService.getCurrentCompanyName();
                Long companyId = this.sessionService.getCompanyId();
                String siteCode = this.sessionService.getCurrentSiteCode();
                logDTO.setLogin(login);
                logDTO.setUserId(userId);
                logDTO.setSiteCode(siteCode);
                logDTO.setElsAccount(elsAccount);
                logDTO.setCompanyName(companyName);
                logDTO.setCompanyId(companyId);
            }
            this.saveDateOperateLog(logDTO);
        }
        catch (Exception e) {
            this.logger.error("Save dataOperationLog error:{}", (Throwable)e);
        }
    }

    public void saveDateOperateLog(DataOperateLogDTO dto) {
        dto.setEnv(this.env);
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel("b2b_data_operate_log_" + this.env);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)dto)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }

    public void afterPropertiesSet() throws Exception {
    }
}

