/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.qqt.platform.common.multitenant.redis.enums.CacheKeySystemEnum;
import com.qqt.platform.common.multitenant.redis.util.CacheKeyNamespaceUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.redisson.hibernate.RedissonRegionFactory;

public class LocalRedissonRegionFactory
extends RedissonRegionFactory {
    private static final long serialVersionUID = -9173587401036877023L;
    private static RedissonClient redissonClient;
    private static String namespace;

    protected RedissonClient createRedissonClient(Map properties) {
        redissonClient = super.createRedissonClient(properties);
        namespace = String.valueOf(properties.getOrDefault("hibernate.cache.second_level_namespace", ""));
        return redissonClient;
    }

    public static RMapCache getMapCache(String regionName) {
        if (redissonClient == null) {
            return null;
        }
        return redissonClient.getMapCache(LocalRedissonRegionFactory.rewriteRegionName(regionName));
    }

    protected RMapCache<Object, Object> getCache(String regionName, Map properties, String defaultKey) {
        return super.getCache(LocalRedissonRegionFactory.rewriteRegionName(regionName), properties, defaultKey);
    }

    private static String rewriteRegionName(String regionName) {
        String system = CacheKeySystemEnum.COMMON.getCode();
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            system = namespace;
        }
        return CacheKeyNamespaceUtil.getSecondLevelCacheKey(system, regionName);
    }
}

