/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.HttpUtil;
import com.qqt.platform.common.multitenant.redis.template.QQTStringRedisTemplate;
import com.qqt.platform.common.mybank.api.internal.util.StringUtils;
import com.qqt.platform.common.service.SessionService;
import com.qqt.platform.common.utils.AESUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SrmFeignClientInterceptor
implements RequestInterceptor {
    private final Logger log = LoggerFactory.getLogger(SrmFeignClientInterceptor.class);
    private static final String AUTHORIZATION_HEADER = "X-Access-Token";
    private static final String BEARER = "Bearer";
    @Value(value="${srm.api.url}")
    private String srmUrl;
    @Value(value="${srm.api.aesKey:m_dossen_wsc_sso}")
    private String aesKey;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private QQTStringRedisTemplate redisTemplate;
    private final String srmToken = "srm:sso:token:";

    public void apply(RequestTemplate template) {
        String els = this.sessionService.getElsAccount();
        String loginAccount = this.sessionService.getOneIdUserId();
        this.log.info("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\uff1aels:{},loginAccount:{},\u5bc6\u94a5\uff1a{}", new Object[]{els, loginAccount, this.aesKey});
        String token = null;
        token = this.redisTemplate.opsForValueGet("srm:sso:token:" + loginAccount);
        if (!StringUtils.isEmpty(token)) {
            template.header(AUTHORIZATION_HEADER, new String[]{token});
        } else {
            token = this.obtainToken(loginAccount, "134712");
            if (!StringUtils.isEmpty(token)) {
                template.header(AUTHORIZATION_HEADER, new String[]{token});
                this.redisTemplate.opsForValueSet("srm:sso:token:" + loginAccount, token, 10L, TimeUnit.MINUTES);
            } else {
                token = this.obtainToken(loginAccount, "134712");
                if (!StringUtils.isEmpty(token)) {
                    template.header(AUTHORIZATION_HEADER, new String[]{token});
                    this.redisTemplate.opsForValueSet("srm:sso:token:" + loginAccount, token, 10L, TimeUnit.MINUTES);
                }
            }
        }
    }

    private String obtainToken(String loginAccount, String els) {
        String token = "";
        try {
            JSONObject obj;
            loginAccount = AESUtils.AESEncrypt(loginAccount, this.aesKey);
            String result = HttpUtil.sendHttpGet((String)(this.srmUrl + "/account/mallLoginSso?loginAccount=" + loginAccount + "&els=" + els));
            if (!StringUtils.isEmpty(result) && Objects.nonNull(obj = JSON.parseObject((String)result))) {
                token = obj.getString("result");
            }
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6srm\u7cfb\u7edftoken\u5931\u8d25\uff1a" + e);
        }
        return token;
    }
}

