/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.dto.pingan.wrap;

import com.alibaba.fastjson.JSONObject;
import com.pingan.openbank.api.sdk.client.ApiClient;
import com.pingan.openbank.api.sdk.common.http.HttpResult;
import com.pingan.openbank.api.sdk.entity.SdkRequest;
import com.qqt.platform.common.config.PingAnConfiguration;
import com.qqt.platform.common.dto.pingan.PingAnRequestBody;
import com.qqt.platform.common.dto.pingan.PingAnResponseBody;
import com.qqt.platform.common.exception.BusinessException;
import com.qqt.platform.common.utils.DateUtil;
import com.qqt.platform.common.utils.SpringApplicationContextUtils;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractWrapper {
    private static final Logger log = LoggerFactory.getLogger(AbstractWrapper.class);
    protected static final String RETURN_CODE = "000000";
    private PingAnRequestBody pingAnRequestBody;

    public BuildResult build() {
        PingAnConfiguration pingAnConfiguration = (PingAnConfiguration)SpringApplicationContextUtils.getBean("pingAnConfiguration");
        String mrchCode = pingAnConfiguration.getMrchCode();
        this.pingAnRequestBody.setMrchCode(mrchCode);
        this.pingAnRequestBody.setTxnTime(DateUtil.genSystemSequenceNumberForPinganTxnTime());
        this.pingAnRequestBody.setCnsmrSeqNo(DateUtil.genSystemSequenceNumberForPinganCnsmrSeqNo(mrchCode));
        if (StringUtils.isEmpty((Object)this.pingAnRequestBody.getTxnCode())) {
            return new BuildResult(false, "\u53c2\u6570\u975e\u6cd5\uff1atxnCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)this.pingAnRequestBody.getTxnClientNo())) {
            return new BuildResult(false, "\u53c2\u6570\u975e\u6cd5\uff1atxnClientNo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.buildBusinessBody();
    }

    protected abstract BuildResult buildBusinessBody();

    public abstract <T> PingAnResponseBody parse(T var1);

    public Map<String, Object> sendRequestBySelf(PingAnRequestBody pingAnRequestBody, String data) {
        Map result = null;
        try {
            SdkRequest sdkRequest = new SdkRequest();
            sdkRequest.setInterfaceName(pingAnRequestBody.getServiceCode());
            sdkRequest.setBody(JSONObject.parse((String)data));
            HttpResult httpResult = (HttpResult)ApiClient.getInstance().invoke(sdkRequest);
            String httpResultData = httpResult.getData();
            JSONObject httpResultJson = (JSONObject)JSONObject.parse((String)httpResultData);
            result = (Map)Map.class.cast(httpResultJson.get((Object)"Data"));
            if (Objects.isNull(result)) {
                result = (Map)Map.class.cast(httpResultJson.get((Object)"ExtendData"));
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5e73\u5b89\u94f6\u884c\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException("50001", "\u8bf7\u6c42\u5e73\u5b89\u94f6\u884c\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (!result.containsKey("TxnReturnCode")) {
            log.error("\u5e73\u5b89\u94f6\u884c sendRequestBySelf data={}", (Object)result);
            throw new BusinessException("50001", "\u8bf7\u6c42\u5e73\u5b89\u94f6\u884c\u5931\u8d25...");
        }
        return result;
    }

    public PingAnRequestBody getPingAnRequestBody() {
        return this.pingAnRequestBody;
    }

    public void setPingAnRequestBody(PingAnRequestBody pingAnRequestBody) {
        this.pingAnRequestBody = pingAnRequestBody;
    }

    public static class BuildResult {
        private boolean success;
        private String message;
        private AbstractWrapper target;

        public BuildResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public BuildResult(boolean success, String message, AbstractWrapper target) {
            this.success = success;
            this.message = message;
            this.target = target;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public AbstractWrapper getTarget() {
            return this.target;
        }

        public void setTarget(AbstractWrapper target) {
            this.target = target;
        }
    }
}

