/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.event;

import com.alibaba.fastjson.JSON;
import com.qqt.platform.common.config.KafkaMessage;
import com.qqt.platform.common.config.ServerConfiguration;
import com.qqt.platform.common.dto.PayLogDTO;
import com.qqt.platform.common.event.PayLogEvent;
import com.qqt.platform.common.utils.KafkaProduceUtil;
import com.qqt.platform.common.utils.LogAbstractUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class PayLogListener {
    private static final Logger log = LoggerFactory.getLogger(PayLogListener.class);
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Autowired
    private ServerConfiguration serverConfiguration;
    @Autowired
    private JHipsterProperties jHipsterProperties;
    @Value(value="${spring.profiles.active}")
    private String env;
    @Value(value="${saveLog.usual.enabled:true}")
    private String enabled;

    @Async
    @Order
    @EventListener(value={PayLogEvent.class})
    public void savePayLog(PayLogEvent event) {
        if (!"true".equals(this.enabled)) {
            return;
        }
        Map source = (Map)event.getSource();
        PayLogDTO payLog = (PayLogDTO)source.get("info");
        payLog.setEnv(this.env);
        LogAbstractUtil.addOtherInfoToLog(payLog, this.jHipsterProperties, this.serverConfiguration);
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel("b2b_pay_log_" + this.env);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)payLog)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }
}

