/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.facade.provide;

import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.UserDTO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.dto.message.BillRelationDTO;
import com.qqt.platform.common.dto.message.UserTargetDTO;
import com.qqt.platform.common.facade.MessageRecevierProvide;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.utils.AdminEntityCacheUtils;
import com.qqt.platform.common.utils.ResultUtil;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;

public abstract class AbstractMessageRecevierProvideImpl
implements MessageRecevierProvide {
    private final Logger log = LoggerFactory.getLogger(AbstractMessageRecevierProvideImpl.class);
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired
    private AdminEntityCacheUtils adminEntityCacheUtils;

    @Override
    public ResultDTO<Set<UserTargetDTO>> getRecevierList(List<BillRelationDTO> billRelationDTOS) {
        this.log.debug("getRecevierList params:{}", billRelationDTOS);
        if (CollectionUtils.isEmpty(billRelationDTOS)) {
            return ResultUtil.fail("getRecevierList params can not empty");
        }
        ResultDTO valid = this.validBillRelationDTO(billRelationDTOS);
        if (!valid.isSuccess()) {
            return valid;
        }
        return this.process(billRelationDTOS);
    }

    public abstract ResultDTO<Set<UserTargetDTO>> process(List<BillRelationDTO> var1);

    private ResultDTO validBillRelationDTO(List<BillRelationDTO> billRelationDTOS) {
        for (BillRelationDTO relation : billRelationDTOS) {
            if (relation.getBillId() == null) {
                return ResultUtil.fail("getRecevierList params BillId is empty");
            }
            if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{relation.getReceIdField(), relation.getReceType(), relation.getTableName()})) continue;
            return ResultUtil.fail("getRecevierList params some is empty");
        }
        return ResultUtil.success();
    }

    public String getCurrentUserName(Long userId) {
        block7: {
            if (userId != null) {
                UserDetailDO userDetailDO = this.adminEntityCacheUtils.getUserDO(userId);
                if (userDetailDO != null) {
                    return userDetailDO.getNameCn();
                }
                UserDTO userDTO = null;
                try {
                    ResponseEntity<ResultDTO<UserDTO>> userEntity = this.adminFeignService.getUserById(userId);
                    if (userEntity != null && userEntity.getBody() != null && ((ResultDTO)userEntity.getBody()).getData() != null) {
                        ResultDTO resultDTO = (ResultDTO)userEntity.getBody();
                        if (resultDTO.getData() != null) {
                            userDTO = (UserDTO)resultDTO.getData();
                            if (StringUtils.isBlank((CharSequence)userDTO.getNameCn())) {
                                return userId + "";
                            }
                            return userDTO.getNameCn();
                        }
                        break block7;
                    }
                    return userId + "";
                }
                catch (Exception e) {
                    this.log.error("getUserDetail userId error,userId:{},error:{}", (Object)userId, (Object)e);
                    return userId + "";
                }
            }
        }
        return null;
    }
}

