/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.builder;

import com.qqt.platform.common.multitenant.builder.DynamicDataSourceBuilder;
import com.qqt.platform.common.multitenant.datasource.MultitenantDynamicDataSource;
import com.qqt.platform.common.multitenant.enums.PlatformDataSourceKeyword;
import com.qqt.platform.common.multitenant.enums.TenantDataSourceKeyword;
import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import com.qqt.platform.common.multitenant.properties.MultitenantDataSourceProperties;
import com.qqt.platform.common.multitenant.properties.MultitenantShardingRuleProperties;
import com.qqt.platform.common.multitenant.remote.dto.RemoteTenantDataSourceConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.api.config.masterslave.LoadBalanceStrategyConfiguration;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.shardingjdbc.api.ShardingDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={MultitenantDataSourceProperties.class, MultitenantShardingRuleProperties.class})
public class MultitenantDynamicDataSourceBuilder
extends DynamicDataSourceBuilder {
    private static final Logger log = LoggerFactory.getLogger(MultitenantDynamicDataSourceBuilder.class);
    private final MultitenantDataSourceProperties multitenantDataSourceProperties;
    private final MultitenantShardingRuleProperties multitenantShardingRuleProperties;
    private final MultitenantDynamicDataSource multitenantDynamicDataSource = new MultitenantDynamicDataSource();
    private final Map<Object, Object> dataSources = new HashMap<Object, Object>();

    public MultitenantDynamicDataSourceBuilder(MultitenantDataSourceProperties multitenantDataSourceProperties, MultitenantShardingRuleProperties multitenantShardingRuleProperties) {
        this.multitenantDataSourceProperties = multitenantDataSourceProperties;
        this.multitenantShardingRuleProperties = multitenantShardingRuleProperties;
    }

    @Override
    public void buildDefaultDataSource(DataSource defaultDataSource) {
        this.multitenantDynamicDataSource.setDefaultTargetDataSource(defaultDataSource);
        this.multitenantDynamicDataSource.setDefaultTenantDataSource(defaultDataSource);
    }

    @Override
    public void buildPlatformDataSource(DataSource platformDataSource) {
        this.dataSources.put(PlatformDataSourceKeyword.PLATFORM.getKeyword(""), platformDataSource);
    }

    @Override
    public void buildTenantDataSource(List<RemoteTenantDataSourceConfig> remoteTenantDataSourceConfigs) throws SQLException {
        if (!CollectionUtils.isEmpty(remoteTenantDataSourceConfigs)) {
            for (RemoteTenantDataSourceConfig remoteTenantDataSourceConfig : remoteTenantDataSourceConfigs) {
                DataSource dataSource;
                if (remoteTenantDataSourceConfig.getSingleInstance() != null) {
                    dataSource = this.getTenantSingleDataSource(remoteTenantDataSourceConfig.getSingleInstance());
                    if (dataSource == null) continue;
                    this.dataSources.put(this.getTenantDynamicDataSourceAlias(remoteTenantDataSourceConfig.getElsAccount()), dataSource);
                    continue;
                }
                if (remoteTenantDataSourceConfig.getMasterSlaveInstance() == null || (dataSource = this.getTenantShardingDataSource(remoteTenantDataSourceConfig.getMasterSlaveInstance())) == null) continue;
                this.dataSources.put(this.getTenantDynamicDataSourceAlias(remoteTenantDataSourceConfig.getElsAccount()), dataSource);
            }
        }
    }

    @Override
    public MultitenantDynamicDataSource build() {
        log.info("build multitenant dynamic datasource...");
        this.multitenantDynamicDataSource.setTargetDataSources(this.dataSources);
        this.multitenantDynamicDataSource.updateTenantDataSources(this.dataSources);
        this.cacheDataSourceKeywords();
        return this.multitenantDynamicDataSource;
    }

    private void cacheDataSourceKeywords() {
        if (!CollectionUtils.isEmpty(this.dataSources)) {
            List<String> keywords = this.dataSources.keySet().stream().map(Object::toString).collect(Collectors.toList());
            log.info("initialized datasource list : {}", keywords);
            DynamicDataSourceContextHolder.addDataSourceKeywords(keywords);
        }
    }

    private DataSource getTenantSingleDataSource(RemoteTenantDataSourceConfig.DataSourceConfig dataSourceConfig) {
        if (dataSourceConfig != null) {
            return this.getHikariDataSource(dataSourceConfig, "write");
        }
        return null;
    }

    private DataSource getTenantShardingDataSource(RemoteTenantDataSourceConfig.MasterSlaveDataSourceConfig masterSlaveDataSourceConfig) throws SQLException {
        if (masterSlaveDataSourceConfig == null || CollectionUtils.isEmpty(masterSlaveDataSourceConfig.getSlaves())) {
            return null;
        }
        ShardingRuleConfiguration shardingRuleConfiguration = new ShardingRuleConfiguration();
        shardingRuleConfiguration.setDefaultDataSourceName(this.multitenantShardingRuleProperties.getDefaultDataSourceName());
        int slaves = masterSlaveDataSourceConfig.getSlaves().size();
        ArrayList<String> slaveDataSourceNames = new ArrayList<String>();
        for (int i = 0; i < slaves; ++i) {
            slaveDataSourceNames.add(this.getSlaveDataSourceName(i));
        }
        LinkedList<MasterSlaveRuleConfiguration> masterSlaveRuleConfigs = new LinkedList<MasterSlaveRuleConfiguration>();
        String loadBalanceAlgorithmType = this.multitenantShardingRuleProperties.getLoadBalanceAlgorithmType();
        MasterSlaveRuleConfiguration masterSlaveRuleConfiguration = new MasterSlaveRuleConfiguration(this.multitenantShardingRuleProperties.getName(), this.multitenantShardingRuleProperties.getMasterDataSourceName(), slaveDataSourceNames, new LoadBalanceStrategyConfiguration(StringUtils.isEmpty((Object)loadBalanceAlgorithmType) ? "ROUND_ROBIN" : loadBalanceAlgorithmType, new Properties()));
        masterSlaveRuleConfigs.add(masterSlaveRuleConfiguration);
        shardingRuleConfiguration.setMasterSlaveRuleConfigs(masterSlaveRuleConfigs);
        Properties props = this.multitenantDataSourceProperties.getProps();
        return ShardingDataSourceFactory.createDataSource(this.getTenantMasterSlaveDataSource(masterSlaveDataSourceConfig), (ShardingRuleConfiguration)shardingRuleConfiguration, (Properties)props);
    }

    private Map<String, DataSource> getTenantMasterSlaveDataSource(RemoteTenantDataSourceConfig.MasterSlaveDataSourceConfig masterSlaveDataSourceConfig) {
        HikariDataSource dataSource;
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        if (masterSlaveDataSourceConfig.getMaster() != null && (dataSource = this.getHikariDataSource(masterSlaveDataSourceConfig.getMaster(), "write")) != null) {
            String key = this.multitenantShardingRuleProperties.getMasterDataSourceName();
            dataSourceMap.put(StringUtils.isEmpty((Object)key) ? "master" : key, (DataSource)dataSource);
        }
        if (!CollectionUtils.isEmpty(masterSlaveDataSourceConfig.getSlaves())) {
            int slaves = masterSlaveDataSourceConfig.getSlaves().size();
            for (int i = 0; i < slaves; ++i) {
                RemoteTenantDataSourceConfig.DataSourceConfig dataSourceConfig = masterSlaveDataSourceConfig.getSlaves().get(i);
                HikariDataSource dataSource2 = this.getHikariDataSource(dataSourceConfig, "read");
                if (dataSource2 == null) continue;
                dataSourceMap.put(this.getSlaveDataSourceName(i), (DataSource)dataSource2);
            }
        }
        return dataSourceMap;
    }

    private String getSlaveDataSourceName(int i) {
        return String.join((CharSequence)"_", "slave", String.valueOf(i));
    }

    public String getTenantDynamicDataSourceAlias(String elsAccount) {
        return TenantDataSourceKeyword.TENANT.getKeyword(elsAccount);
    }

    private HikariDataSource getHikariDataSource(RemoteTenantDataSourceConfig.DataSourceConfig dataSourceConfig, String poolName) {
        try {
            HikariDataSource dataSource = new HikariDataSource();
            dataSource.setDriverClassName(dataSourceConfig.getDriverClassName());
            dataSource.setJdbcUrl(dataSourceConfig.getJdbcUrl());
            dataSource.setUsername(dataSourceConfig.getUsername());
            dataSource.setPassword(dataSourceConfig.getPassword());
            dataSource.setPoolName(poolName);
            dataSource.setMaximumPoolSize(this.multitenantDataSourceProperties.getMaxPoolSize().intValue());
            dataSource.setMinimumIdle(this.multitenantDataSourceProperties.getMinIdle().intValue());
            dataSource.setAutoCommit(this.multitenantDataSourceProperties.getAutoCommit().booleanValue());
            dataSource.setIdleTimeout(this.multitenantDataSourceProperties.getIdleTimeout().longValue());
            dataSource.setConnectionTimeout(this.multitenantDataSourceProperties.getConnectionTimeout().longValue());
            dataSource.setValidationTimeout(this.multitenantDataSourceProperties.getValidationTimeout().longValue());
            dataSource.setMaxLifetime(this.multitenantDataSourceProperties.getMaxLifetime().longValue());
            dataSource.setLoginTimeout(this.multitenantDataSourceProperties.getLoginTimeout().intValue());
            Properties dsProperties = new Properties();
            dsProperties.put("cachePrepStmts", this.multitenantDataSourceProperties.getCachePrepStmts());
            dsProperties.put("prepStmtCacheSize", this.multitenantDataSourceProperties.getPrepStmtCacheSize());
            dsProperties.put("prepStmtCacheSqlLimit", this.multitenantDataSourceProperties.getPrepStmtCacheSqlLimit());
            dsProperties.put("useServerPrepStmts", this.multitenantDataSourceProperties.getUseServerPrepStmts());
            dataSource.setDataSourceProperties(dsProperties);
            return dataSource;
        }
        catch (Exception e) {
            log.error("\u521b\u5efaHikariDataSource\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public Map<Object, Object> getDataSources() {
        return this.dataSources;
    }
}

