/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.configuration;

import com.qqt.platform.common.multitenant.builder.MultitenantDynamicDataSourceBuilder;
import com.qqt.platform.common.multitenant.configuration.YamlShardingDatasourceConfiguration;
import com.qqt.platform.common.multitenant.datasource.MultitenantDynamicDataSource;
import com.qqt.platform.common.multitenant.remote.query.RemoteTenantDataSourceQuerier;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@AutoConfigureAfter(value={YamlShardingDatasourceConfiguration.class})
@ConditionalOnProperty(prefix="multitenant", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class DynamicDataSourceConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceConfiguration.class);
    @Value(value="${spring.application.name}")
    private String appName;
    private final RemoteTenantDataSourceQuerier remoteTenantDataSourceQuerier;
    private final MultitenantDynamicDataSourceBuilder multitenantDynamicDataSourceBuilder;

    public DynamicDataSourceConfiguration(RemoteTenantDataSourceQuerier remoteTenantDataSourceQuerier, MultitenantDynamicDataSourceBuilder multitenantDynamicDataSourceBuilder) {
        this.remoteTenantDataSourceQuerier = remoteTenantDataSourceQuerier;
        this.multitenantDynamicDataSourceBuilder = multitenantDynamicDataSourceBuilder;
    }

    @Primary
    @Bean(value={"dataSource"})
    public MultitenantDynamicDataSource dataSource(@Qualifier(value="shardingDataSource") DataSource shardingDataSource) throws SQLException {
        log.info("initialize multitenant dynamic datasource......");
        this.multitenantDynamicDataSourceBuilder.buildDefaultDataSource(shardingDataSource);
        this.multitenantDynamicDataSourceBuilder.buildPlatformDataSource(shardingDataSource);
        this.multitenantDynamicDataSourceBuilder.buildTenantDataSource(this.remoteTenantDataSourceQuerier.queryRemoteTenantDataSourceConfig(this.appName));
        return this.multitenantDynamicDataSourceBuilder.build();
    }

    @Primary
    @Bean(value={"transactionManager"})
    public DataSourceTransactionManager transactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}

