/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.configuration;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.config.inline.InlineExpressionParser;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.core.yaml.config.sharding.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.core.yaml.swapper.impl.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.shardingjdbc.api.ShardingDataSourceFactory;
import org.apache.shardingsphere.shardingjdbc.spring.boot.common.SpringBootPropertiesConfigurationProperties;
import org.apache.shardingsphere.shardingjdbc.spring.boot.sharding.SpringBootShardingRuleConfigurationProperties;
import org.apache.shardingsphere.spring.boot.datasource.DataSourcePropertiesSetter;
import org.apache.shardingsphere.spring.boot.datasource.DataSourcePropertiesSetterHolder;
import org.apache.shardingsphere.spring.boot.util.DataSourceUtil;
import org.apache.shardingsphere.spring.boot.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;

@Configuration
@ComponentScan(value={"org.apache.shardingsphere.spring.boot.converter"})
@EnableConfigurationProperties(value={SpringBootShardingRuleConfigurationProperties.class, SpringBootPropertiesConfigurationProperties.class})
@ConditionalOnProperty(prefix="multitenant", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class YamlShardingDatasourceConfiguration
implements EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(YamlShardingDatasourceConfiguration.class);
    private final SpringBootShardingRuleConfigurationProperties shardingRule;
    private final SpringBootPropertiesConfigurationProperties props;
    private final Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();

    public YamlShardingDatasourceConfiguration(SpringBootShardingRuleConfigurationProperties shardingRule, SpringBootPropertiesConfigurationProperties props) {
        this.shardingRule = shardingRule;
        this.props = props;
    }

    @Bean(value={"shardingDataSource"})
    public DataSource shardingDataSource() throws SQLException {
        log.info("initialize default sharding datasource...");
        return ShardingDataSourceFactory.createDataSource(this.dataSourceMap, (ShardingRuleConfiguration)new ShardingRuleConfigurationYamlSwapper().swap((YamlShardingRuleConfiguration)this.shardingRule), (Properties)this.props.getProps());
    }

    public final void setEnvironment(Environment environment) {
        String prefix = "spring.shardingsphere.datasource.";
        for (String each : this.getDataSourceNames(environment, prefix)) {
            try {
                this.dataSourceMap.put(each, this.getDataSource(environment, prefix, each));
            }
            catch (ReflectiveOperationException ex) {
                throw new ShardingException("Can't find datasource type!", (Exception)ex);
            }
            catch (NamingException namingEx) {
                throw new ShardingException("Can't find JNDI datasource!", (Exception)namingEx);
            }
        }
    }

    private List<String> getDataSourceNames(Environment environment, String prefix) {
        StandardEnvironment standardEnv = (StandardEnvironment)environment;
        standardEnv.setIgnoreUnresolvableNestedPlaceholders(true);
        return null == standardEnv.getProperty(prefix + "name") ? new InlineExpressionParser(standardEnv.getProperty(prefix + "names")).splitAndEvaluate() : Collections.singletonList(standardEnv.getProperty(prefix + "name"));
    }

    private DataSource getDataSource(Environment environment, String prefix, String dataSourceName) throws ReflectiveOperationException, NamingException {
        Map dataSourceProps = (Map)PropertyUtil.handle((Environment)environment, (String)(prefix + dataSourceName.trim()), Map.class);
        Preconditions.checkState((!dataSourceProps.isEmpty() ? 1 : 0) != 0, (Object)"Wrong datasource properties!");
        DataSource result = DataSourceUtil.getDataSource((String)dataSourceProps.get("type").toString(), (Map)dataSourceProps);
        Optional dataSourcePropertiesSetter = DataSourcePropertiesSetterHolder.getDataSourcePropertiesSetterByType((String)dataSourceProps.get("type").toString());
        if (dataSourcePropertiesSetter.isPresent()) {
            ((DataSourcePropertiesSetter)dataSourcePropertiesSetter.get()).propertiesSet(environment, prefix, dataSourceName, result);
        }
        return result;
    }
}

