/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.redis.template;

import com.qqt.platform.common.multitenant.enums.PlatformDataSourceKeyword;
import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import com.qqt.platform.common.multitenant.redis.util.CacheKeyNamespaceUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class QQTStringRedisTemplate {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${spring.application.name}")
    private String appName;

    public void opsForValueSet(String key, String value, long timeout, TimeUnit unit, boolean isCommonCache) {
        if (isCommonCache) {
            this.stringRedisTemplate.opsForValue().set((Object)this.rewriteCommonCacheKey(key), (Object)value, timeout, unit);
        } else {
            this.opsForValueSet(key, value, timeout, unit);
        }
    }

    public void opsForValueSet(String key, String value, long timeout, TimeUnit unit) {
        this.stringRedisTemplate.opsForValue().set((Object)this.rewriteCacheKey(key), (Object)value, timeout, unit);
    }

    public void opsForValueSet(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)this.rewriteCacheKey(key), (Object)value);
    }

    public String opsForValueGet(String key, boolean isCommonCache) {
        if (isCommonCache) {
            return (String)this.stringRedisTemplate.opsForValue().get((Object)this.rewriteCommonCacheKey(key));
        }
        return this.opsForValueGet(key);
    }

    public String opsForValueGet(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)this.rewriteCacheKey(key));
    }

    public Set<String> opsForSetMembers(String key) {
        return this.stringRedisTemplate.opsForSet().members((Object)this.rewriteCacheKey(key));
    }

    public Long opsForSetAddMember(String key, String ... values) {
        return this.stringRedisTemplate.opsForSet().add((Object)this.rewriteCacheKey(key), (Object[])values);
    }

    public Set<String> keys(String pattern) {
        return this.stringRedisTemplate.keys((Object)this.rewriteCacheKey(pattern));
    }

    public Boolean delete(String key, boolean isCommonCache) {
        if (isCommonCache) {
            return this.stringRedisTemplate.delete((Object)this.rewriteCommonCacheKey(key));
        }
        return this.delete(key);
    }

    public Boolean delete(String key) {
        return this.stringRedisTemplate.delete((Object)this.rewriteCacheKey(key));
    }

    public Boolean delete(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return false;
        }
        List rewriteKeys = keys.stream().map(key -> this.rewriteCacheKey((String)key)).collect(Collectors.toList());
        this.stringRedisTemplate.delete(rewriteKeys);
        return true;
    }

    public Long deleteWithRewriteKeys(Collection<String> keys) {
        return this.stringRedisTemplate.delete(keys);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit, boolean isCommonCache) {
        if (isCommonCache) {
            return this.stringRedisTemplate.expire((Object)this.rewriteCommonCacheKey(key), timeout, unit);
        }
        return this.expire(key, timeout, unit);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit) {
        return this.stringRedisTemplate.expire((Object)this.rewriteCacheKey(key), timeout, unit);
    }

    private String rewriteCacheKey(String originalKey) {
        String dskey = DynamicDataSourceContextHolder.getDataSourceKey();
        if (PlatformDataSourceKeyword.PLATFORM.getKeyword("").equals(dskey)) {
            return CacheKeyNamespaceUtil.getPlatformCacheKey(this.appName, originalKey);
        }
        String elsAccount = dskey.split("_")[1];
        return CacheKeyNamespaceUtil.getTenantCacheKey(this.appName, elsAccount, originalKey);
    }

    private String rewriteCommonCacheKey(String originalKey) {
        return CacheKeyNamespaceUtil.getCommonSystemCacheKey(originalKey);
    }

    public void deleteByKeyPattern(String key) {
        String rkey = this.rewriteCacheKey(key);
        Set keys = this.stringRedisTemplate.keys((Object)rkey);
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.stringRedisTemplate.delete((Collection)keys);
        }
    }
}

