/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.remote.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.multitenant.properties.TenantProperties;
import com.qqt.platform.common.multitenant.remote.dto.RemoteTenantDataSourceConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class RemoteTenantDataSourceQuerier {
    private static final Logger log = LoggerFactory.getLogger(RemoteTenantDataSourceQuerier.class);
    private final RestTemplate restTemplate;
    @Autowired
    private TenantProperties tenantProperties;

    public RemoteTenantDataSourceQuerier(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public List<RemoteTenantDataSourceConfig> queryRemoteTenantDataSourceConfig(String ... params) {
        try {
            if (!this.tenantProperties.getEnabled().booleanValue()) {
                log.info("not enabled multitenant datasource...");
                return null;
            }
            log.info("query multitenant datasource config, param is : {}", (Object[])params);
            String url = String.format(this.tenantProperties.getConfigApi(), params);
            String resultDTO = (String)this.restTemplate.getForObject(url, String.class, new HashMap());
            if (StringUtils.isEmpty((Object)resultDTO)) {
                log.warn("query multitenant datasource is null...");
                return null;
            }
            ResultDTO tenantDataSourceConfigDTO = (ResultDTO)JSON.parseObject((String)resultDTO, (TypeReference)new TypeReference<ResultDTO<List<RemoteTenantDataSourceConfig>>>(){}, (Feature[])new Feature[0]);
            if (CollectionUtils.isEmpty((Collection)((Collection)tenantDataSourceConfigDTO.getData()))) {
                log.warn("query multitenant datasource is null...");
            }
            return (List)tenantDataSourceConfigDTO.getData();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u79df\u6237\u670d\u52a1\uff0c\u83b7\u53d6\u79df\u6237\u6570\u636e\u6e90\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

