/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.selector;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class DefaultDataSourceAutoConfigurationSelector
implements ImportSelector,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataSourceAutoConfigurationSelector.class);
    private static final String DEFAULT_AUTO_CONFIGURATION_CLASS = "org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration";
    private static final String SHARDING_JDBC_AUTO_CONFIGURATION_CLASS = "org.apache.shardingsphere.shardingjdbc.spring.boot.SpringBootConfiguration";
    private Boolean multitenantEnabled = false;
    private Boolean shardingsphereEnabled = false;

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        ArrayList<String> classNameList = new ArrayList<String>();
        if (Objects.isNull(this.multitenantEnabled) || !this.multitenantEnabled.booleanValue()) {
            if (Objects.nonNull(this.shardingsphereEnabled) && this.shardingsphereEnabled.booleanValue()) {
                classNameList.add(SHARDING_JDBC_AUTO_CONFIGURATION_CLASS);
                log.info("Automatic assemble sharding datasource...");
            } else {
                classNameList.add(DEFAULT_AUTO_CONFIGURATION_CLASS);
                log.info("Automatic assemble default datasource...");
            }
        }
        return StringUtils.toStringArray(classNameList);
    }

    public void setEnvironment(Environment environment) {
        StandardEnvironment standardEnv = (StandardEnvironment)environment;
        standardEnv.setIgnoreUnresolvableNestedPlaceholders(true);
        this.multitenantEnabled = BooleanUtils.toBooleanObject((String)standardEnv.getProperty("multitenant.enabled"));
        this.shardingsphereEnabled = BooleanUtils.toBooleanObject((String)standardEnv.getProperty("spring.shardingsphere.enabled"));
    }
}

